/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.tools;

import java.util.Iterator;
import java.util.zip.ZipEntry;
import org.springframework.boot.jarmode.tools.Context;
import org.springframework.boot.jarmode.tools.IndexedLayers;

interface Layers
extends Iterable<String> {
    @Override
    public Iterator<String> iterator();

    default public String getLayer(ZipEntry entry) {
        return this.getLayer(entry.getName());
    }

    public String getLayer(String var1);

    public String getApplicationLayerName();

    public static Layers get(Context context) {
        IndexedLayers indexedLayers = IndexedLayers.get(context);
        if (indexedLayers == null) {
            throw new LayersNotEnabledException();
        }
        return indexedLayers;
    }

    public static final class LayersNotEnabledException
    extends RuntimeException {
        LayersNotEnabledException() {
            super("Layers not enabled: Failed to load layer index file");
        }
    }
}

