/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.actions.sequence.SequenceId;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.ArrayUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.layout.element.TabStop;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.LineLayoutContext;
import com.itextpdf.layout.layout.LineLayoutResult;
import com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import com.itextpdf.layout.layout.TextLayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.properties.FloatPropertyValue;
import com.itextpdf.layout.properties.Leading;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.RenderingMode;
import com.itextpdf.layout.properties.TabAlignment;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.ILeafElementRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.LineHeightHelper;
import com.itextpdf.layout.renderer.MaxSumWidthHandler;
import com.itextpdf.layout.renderer.MetaInfoContainer;
import com.itextpdf.layout.renderer.SumSumWidthHandler;
import com.itextpdf.layout.renderer.TabRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import com.itextpdf.layout.renderer.TargetCounterHandler;
import com.itextpdf.layout.renderer.TextRenderer;
import com.itextpdf.layout.renderer.TextSequenceWordWrapping;
import com.itextpdf.layout.renderer.TypographyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineRenderer
extends AbstractRenderer {
    private static final float MIN_MAX_WIDTH_CORRECTION_EPS = 0.001f;
    private static final Logger logger = LoggerFactory.getLogger(LineRenderer.class);
    protected float maxAscent;
    protected float maxDescent;
    protected byte[] levels;
    float maxTextAscent;
    float maxTextDescent;
    private float maxBlockAscent;
    private float maxBlockDescent;

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        LineRenderer toProcess;
        LineLayoutContext lineLayoutContext;
        boolean textSequenceOverflowXProcessing = false;
        int firstChildToRelayout = -1;
        Rectangle layoutBox = layoutContext.getArea().getBBox().clone();
        boolean wasParentsHeightClipped = layoutContext.isClippedHeight();
        List<Rectangle> floatRendererAreas = layoutContext.getFloatRendererAreas();
        OverflowPropertyValue oldXOverflow = null;
        boolean wasXOverflowChanged = false;
        boolean floatsPlacedBeforeLine = false;
        if (floatRendererAreas != null) {
            float layoutWidth = layoutBox.getWidth();
            float layoutHeight = layoutBox.getHeight();
            FloatingHelper.adjustLineAreaAccordingToFloats(floatRendererAreas, layoutBox);
            if (layoutWidth > layoutBox.getWidth() || layoutHeight > layoutBox.getHeight()) {
                floatsPlacedBeforeLine = true;
                oldXOverflow = (OverflowPropertyValue)((Object)this.getProperty(103));
                wasXOverflowChanged = true;
                this.setProperty(103, (Object)OverflowPropertyValue.FIT);
            }
        }
        boolean noSoftWrap = Boolean.TRUE.equals(this.getOwnProperty(118));
        LineLayoutContext lineLayoutContext2 = lineLayoutContext = layoutContext instanceof LineLayoutContext ? (LineLayoutContext)layoutContext : new LineLayoutContext(layoutContext);
        if (lineLayoutContext.getTextIndent() != 0.0f) {
            layoutBox.moveRight(lineLayoutContext.getTextIndent()).setWidth(layoutBox.getWidth() - lineLayoutContext.getTextIndent());
        }
        this.occupiedArea = new LayoutArea(layoutContext.getArea().getPageNumber(), layoutBox.clone().moveUp(layoutBox.getHeight()).setHeight(0.0f).setWidth(0.0f));
        this.updateChildrenParent();
        TargetCounterHandler.addPageByID(this);
        float curWidth = 0.0f;
        if (RenderingMode.HTML_MODE.equals(this.getProperty(123)) && this.hasChildRendererInHtmlMode()) {
            float[] ascenderDescender = LineHeightHelper.getActualAscenderDescender(this);
            this.maxAscent = ascenderDescender[0];
            this.maxDescent = ascenderDescender[1];
        } else {
            this.maxAscent = 0.0f;
            this.maxDescent = 0.0f;
        }
        this.maxTextAscent = 0.0f;
        this.maxTextDescent = 0.0f;
        this.maxBlockAscent = -1.0E20f;
        this.maxBlockDescent = 1.0E20f;
        int childPos = 0;
        MinMaxWidth minMaxWidth = new MinMaxWidth();
        AbstractWidthHandler widthHandler = noSoftWrap ? new SumSumWidthHandler(minMaxWidth) : new MaxSumWidthHandler(minMaxWidth);
        this.resolveChildrenFonts();
        int totalNumberOfTrimmedGlyphs = this.trimFirst();
        BaseDirection baseDirection = this.applyOtf();
        this.updateBidiLevels(totalNumberOfTrimmedGlyphs, baseDirection);
        boolean anythingPlaced = false;
        TabStop hangingTabStop = null;
        LayoutResult result = null;
        boolean floatsPlacedInLine = false;
        LinkedHashMap<Integer, IRenderer> floatsToNextPageSplitRenderers = new LinkedHashMap<Integer, IRenderer>();
        ArrayList<IRenderer> floatsToNextPageOverflowRenderers = new ArrayList<IRenderer>();
        ArrayList<IRenderer> floatsOverflowedToNextLine = new ArrayList<IRenderer>();
        int lastTabIndex = 0;
        HashMap<Integer, LayoutResult> specialScriptLayoutResults = new HashMap<Integer, LayoutResult>();
        HashMap<Integer, LayoutResult> textRendererLayoutResults = new HashMap<Integer, LayoutResult>();
        HashMap<Integer, float[]> textRendererSequenceAscentDescent = new HashMap<Integer, float[]>();
        LineAscentDescentState lineAscentDescentStateBeforeTextRendererSequence = null;
        TextSequenceWordWrapping.MinMaxWidthOfTextRendererSequenceHelper minMaxWidthOfTextRendererSequenceHelper = null;
        while (childPos < this.getChildRenderers().size()) {
            boolean newLineOccurred;
            boolean isChildFloating;
            IRenderer childRenderer = this.getChildRenderers().get(childPos);
            LayoutResult childResult = null;
            Rectangle bbox = new Rectangle(layoutBox.getX() + curWidth, layoutBox.getY(), layoutBox.getWidth() - curWidth, layoutBox.getHeight());
            RenderingMode childRenderingMode = (RenderingMode)((Object)childRenderer.getProperty(123));
            if (TextSequenceWordWrapping.isTextRendererAndRequiresSpecialScriptPreLayoutProcessing(childRenderer) && TypographyUtils.isPdfCalligraphAvailable()) {
                TextSequenceWordWrapping.processSpecialScriptPreLayout(this, childPos);
            }
            TextSequenceWordWrapping.resetTextSequenceIfItEnded(specialScriptLayoutResults, true, childRenderer, childPos, minMaxWidthOfTextRendererSequenceHelper, noSoftWrap, widthHandler);
            TextSequenceWordWrapping.resetTextSequenceIfItEnded(textRendererLayoutResults, false, childRenderer, childPos, minMaxWidthOfTextRendererSequenceHelper, noSoftWrap, widthHandler);
            if (childRenderer instanceof TextRenderer) {
                childRenderer.deleteOwnProperty(15);
                childRenderer.deleteOwnProperty(78);
            } else if (childRenderer instanceof TabRenderer) {
                if (hangingTabStop != null) {
                    IRenderer tabRenderer = this.getChildRenderers().get(childPos - 1);
                    tabRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox), wasParentsHeightClipped));
                    curWidth += tabRenderer.getOccupiedArea().getBBox().getWidth();
                    widthHandler.updateMaxChildWidth(tabRenderer.getOccupiedArea().getBBox().getWidth());
                }
                hangingTabStop = this.calculateTab(childRenderer, curWidth, layoutBox.getWidth());
                if (childPos == this.getChildRenderers().size() - 1) {
                    hangingTabStop = null;
                }
                if (hangingTabStop != null) {
                    lastTabIndex = childPos++;
                    continue;
                }
            }
            if (hangingTabStop != null && hangingTabStop.getTabAlignment() == TabAlignment.ANCHOR && childRenderer instanceof TextRenderer) {
                childRenderer.setProperty(66, hangingTabStop.getTabAnchor());
            }
            Object childWidth = childRenderer.getProperty(77);
            boolean childWidthWasReplaced = false;
            boolean childRendererHasOwnWidthProperty = childRenderer.hasOwnProperty(77);
            if (childWidth instanceof UnitValue && ((UnitValue)childWidth).isPercentValue()) {
                float normalizedChildWidth = ((UnitValue)childWidth).getValue() / 100.0f * layoutContext.getArea().getBBox().getWidth();
                if ((normalizedChildWidth = this.decreaseRelativeWidthByChildAdditionalWidth(childRenderer, normalizedChildWidth)) > 0.0f) {
                    childRenderer.setProperty(77, UnitValue.createPointValue(normalizedChildWidth));
                    childWidthWasReplaced = true;
                }
            }
            FloatPropertyValue kidFloatPropertyVal = (FloatPropertyValue)((Object)childRenderer.getProperty(99));
            boolean bl = isChildFloating = childRenderer instanceof AbstractRenderer && FloatingHelper.isRendererFloating(childRenderer, kidFloatPropertyVal);
            if (isChildFloating) {
                childResult = null;
                MinMaxWidth kidMinMaxWidth = FloatingHelper.calculateMinMaxWidthForFloat((AbstractRenderer)childRenderer, kidFloatPropertyVal);
                float floatingBoxFullWidth = kidMinMaxWidth.getMaxWidth();
                if (!wasXOverflowChanged && childPos > 0) {
                    oldXOverflow = (OverflowPropertyValue)((Object)this.getProperty(103));
                    wasXOverflowChanged = true;
                    this.setProperty(103, (Object)OverflowPropertyValue.FIT);
                }
                if (!lineLayoutContext.isFloatOverflowedToNextPageWithNothing() && floatsOverflowedToNextLine.isEmpty() && (!anythingPlaced || floatingBoxFullWidth <= bbox.getWidth())) {
                    childResult = childRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), layoutContext.getArea().getBBox().clone()), null, floatRendererAreas, wasParentsHeightClipped));
                }
                if (childWidthWasReplaced) {
                    if (childRendererHasOwnWidthProperty) {
                        childRenderer.setProperty(77, childWidth);
                    } else {
                        childRenderer.deleteOwnProperty(77);
                    }
                }
                float minChildWidth = 0.0f;
                float maxChildWidth = 0.0f;
                if (childResult instanceof MinMaxWidthLayoutResult) {
                    if (!childWidthWasReplaced) {
                        minChildWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth().getMinWidth();
                    }
                    maxChildWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth().getMaxWidth();
                    widthHandler.updateMinChildWidth(minChildWidth + 1.0E-4f);
                    widthHandler.updateMaxChildWidth(maxChildWidth + 1.0E-4f);
                } else {
                    widthHandler.updateMinChildWidth(kidMinMaxWidth.getMinWidth() + 1.0E-4f);
                    widthHandler.updateMaxChildWidth(kidMinMaxWidth.getMaxWidth() + 1.0E-4f);
                }
                if (childResult == null && !lineLayoutContext.isFloatOverflowedToNextPageWithNothing()) {
                    floatsOverflowedToNextLine.add(childRenderer);
                } else if (lineLayoutContext.isFloatOverflowedToNextPageWithNothing() || childResult.getStatus() == 3) {
                    floatsToNextPageSplitRenderers.put(childPos, null);
                    floatsToNextPageOverflowRenderers.add(childRenderer);
                    lineLayoutContext.setFloatOverflowedToNextPageWithNothing(true);
                } else if (childResult.getStatus() == 2) {
                    floatsPlacedInLine = true;
                    if (childRenderer instanceof TextRenderer) {
                        LineRenderer[] split = this.splitNotFittingFloat(childPos, childResult);
                        IRenderer splitRenderer = childResult.getSplitRenderer();
                        if (splitRenderer instanceof TextRenderer) {
                            ((TextRenderer)splitRenderer).trimFirst();
                            ((TextRenderer)splitRenderer).trimLast();
                        }
                        splitRenderer.getOccupiedArea().getBBox().setWidth(layoutContext.getArea().getBBox().getWidth());
                        result = new LineLayoutResult(2, this.occupiedArea, split[0], split[1], null);
                        break;
                    }
                    floatsToNextPageSplitRenderers.put(childPos, childResult.getSplitRenderer());
                    floatsToNextPageOverflowRenderers.add(childResult.getOverflowRenderer());
                    this.adjustLineOnFloatPlaced(layoutBox, childPos, kidFloatPropertyVal, childResult.getSplitRenderer().getOccupiedArea().getBBox());
                } else {
                    floatsPlacedInLine = true;
                    if (childRenderer instanceof TextRenderer) {
                        ((TextRenderer)childRenderer).trimFirst();
                        ((TextRenderer)childRenderer).trimLast();
                    }
                    this.adjustLineOnFloatPlaced(layoutBox, childPos, kidFloatPropertyVal, childRenderer.getOccupiedArea().getBBox());
                }
                ++childPos;
                if (anythingPlaced || childResult == null || childResult.getStatus() != 3 || !floatRendererAreas.isEmpty() || !this.isFirstOnRootArea()) continue;
                break;
            }
            MinMaxWidth childBlockMinMaxWidth = null;
            boolean isInlineBlockChild = LineRenderer.isInlineBlockChild(childRenderer);
            if (!childWidthWasReplaced && isInlineBlockChild && childRenderer instanceof AbstractRenderer) {
                childBlockMinMaxWidth = ((AbstractRenderer)childRenderer).getMinMaxWidth();
                float childMaxWidth = childBlockMinMaxWidth.getMaxWidth();
                float lineFullAvailableWidth = layoutContext.getArea().getBBox().getWidth() - lineLayoutContext.getTextIndent();
                if (!noSoftWrap && childMaxWidth > bbox.getWidth() + 0.001f && bbox.getWidth() != lineFullAvailableWidth) {
                    childResult = new LineLayoutResult(3, null, null, childRenderer, childRenderer);
                } else {
                    float inlineBlockWidth = Math.min(childMaxWidth += 0.001f, lineFullAvailableWidth);
                    if (!LineRenderer.isOverflowFit((OverflowPropertyValue)((Object)this.getProperty(103)))) {
                        float childMinWidth = childBlockMinMaxWidth.getMinWidth() + 0.001f;
                        inlineBlockWidth = Math.max(childMinWidth, inlineBlockWidth);
                    }
                    bbox.setWidth(inlineBlockWidth);
                    if (childBlockMinMaxWidth.getMinWidth() > bbox.getWidth()) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("Inline block element does not fit into parent element and will be clipped");
                        }
                        childRenderer.setProperty(26, true);
                    }
                }
                childBlockMinMaxWidth.setChildrenMaxWidth(childBlockMinMaxWidth.getChildrenMaxWidth() + 0.001f);
                childBlockMinMaxWidth.setChildrenMinWidth(childBlockMinMaxWidth.getChildrenMinWidth() + 0.001f);
            }
            boolean shouldBreakLayouting = false;
            if (childResult == null) {
                boolean setOverflowFitCausedByTextRendererInHtmlMode;
                boolean setOverflowFitCausedBySpecialScripts = childRenderer instanceof TextRenderer && ((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(true);
                boolean bl2 = setOverflowFitCausedByTextRendererInHtmlMode = RenderingMode.HTML_MODE == childRenderingMode && childRenderer instanceof TextRenderer && !((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(true);
                if (!wasXOverflowChanged && (childPos > 0 || setOverflowFitCausedBySpecialScripts || setOverflowFitCausedByTextRendererInHtmlMode) && !textSequenceOverflowXProcessing) {
                    oldXOverflow = (OverflowPropertyValue)((Object)this.getProperty(103));
                    wasXOverflowChanged = true;
                    this.setProperty(103, (Object)OverflowPropertyValue.FIT);
                }
                TextSequenceWordWrapping.preprocessTextSequenceOverflowX(this, textSequenceOverflowXProcessing, childRenderer, wasXOverflowChanged, oldXOverflow);
                childResult = childRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox), wasParentsHeightClipped));
                shouldBreakLayouting = TextSequenceWordWrapping.postprocessTextSequenceOverflowX(this, textSequenceOverflowXProcessing, childPos, childRenderer, childResult, wasXOverflowChanged);
                TextSequenceWordWrapping.updateTextSequenceLayoutResults(textRendererLayoutResults, false, childRenderer, childPos, childResult);
                TextSequenceWordWrapping.updateTextSequenceLayoutResults(specialScriptLayoutResults, true, childRenderer, childPos, childResult);
                if (childResult instanceof MinMaxWidthLayoutResult && null != childBlockMinMaxWidth) {
                    MinMaxWidth childResultMinMaxWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth();
                    childResultMinMaxWidth.setChildrenMaxWidth(childResultMinMaxWidth.getChildrenMaxWidth() + 0.001f);
                    childResultMinMaxWidth.setChildrenMinWidth(childResultMinMaxWidth.getChildrenMinWidth() + 0.001f);
                }
            }
            if (childWidthWasReplaced) {
                if (childRendererHasOwnWidthProperty) {
                    childRenderer.setProperty(77, childWidth);
                } else {
                    childRenderer.deleteOwnProperty(77);
                }
            }
            float minChildWidth = 0.0f;
            float maxChildWidth = 0.0f;
            if (childResult instanceof MinMaxWidthLayoutResult) {
                if (!childWidthWasReplaced) {
                    minChildWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth().getMinWidth();
                }
                maxChildWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth().getMaxWidth();
            } else if (childBlockMinMaxWidth != null) {
                minChildWidth = childBlockMinMaxWidth.getMinWidth();
                maxChildWidth = childBlockMinMaxWidth.getMaxWidth();
            }
            float[] childAscentDescent = this.getAscentDescentOfLayoutedChildRenderer(childRenderer, childResult, childRenderingMode, isInlineBlockChild);
            lineAscentDescentStateBeforeTextRendererSequence = TextSequenceWordWrapping.updateTextRendererSequenceAscentDescent(this, textRendererSequenceAscentDescent, childPos, childAscentDescent, lineAscentDescentStateBeforeTextRendererSequence);
            minMaxWidthOfTextRendererSequenceHelper = TextSequenceWordWrapping.updateTextRendererSequenceMinMaxWidth(this, widthHandler, childPos, minMaxWidthOfTextRendererSequenceHelper, anythingPlaced, textRendererLayoutResults, specialScriptLayoutResults, lineLayoutContext.getTextIndent());
            boolean bl3 = newLineOccurred = childResult instanceof TextLayoutResult && ((TextLayoutResult)childResult).isSplitForcedByNewline();
            if (!shouldBreakLayouting) {
                shouldBreakLayouting = childResult.getStatus() != 1 || newLineOccurred;
            }
            boolean shouldBreakLayoutingOnTextRenderer = shouldBreakLayouting && childResult instanceof TextLayoutResult;
            boolean forceOverflowForTextRendererPartialResult = false;
            if (shouldBreakLayoutingOnTextRenderer) {
                boolean enableTextSequenceWrapping;
                boolean isWordHasBeenSplitLayoutRenderingMode = ((TextLayoutResult)childResult).isWordHasBeenSplit() && RenderingMode.HTML_MODE != childRenderingMode && !((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(true);
                boolean enableSpecialScriptsWrapping = ((TextRenderer)this.getChildRenderers().get(childPos)).textContainsSpecialScriptGlyphs(true) && !textSequenceOverflowXProcessing && !newLineOccurred;
                boolean bl4 = enableTextSequenceWrapping = RenderingMode.HTML_MODE == childRenderingMode && !newLineOccurred && !textSequenceOverflowXProcessing;
                if (isWordHasBeenSplitLayoutRenderingMode) {
                    forceOverflowForTextRendererPartialResult = this.isForceOverflowForTextRendererPartialResult(childRenderer, wasXOverflowChanged, oldXOverflow, layoutContext, layoutBox, wasParentsHeightClipped);
                } else if (enableSpecialScriptsWrapping) {
                    boolean isOverflowFit = wasXOverflowChanged ? oldXOverflow == OverflowPropertyValue.FIT : LineRenderer.isOverflowFit((OverflowPropertyValue)((Object)this.getProperty(103)));
                    TextSequenceWordWrapping.LastFittingChildRendererData lastFittingChildRendererData = TextSequenceWordWrapping.getIndexAndLayoutResultOfTheLastTextRendererContainingSpecialScripts(this, childPos, specialScriptLayoutResults, wasParentsHeightClipped, isOverflowFit);
                    if (lastFittingChildRendererData == null) {
                        textSequenceOverflowXProcessing = true;
                        shouldBreakLayouting = false;
                        firstChildToRelayout = childPos;
                    } else {
                        curWidth -= TextSequenceWordWrapping.getCurWidthRelayoutedTextSequenceDecrement(childPos, lastFittingChildRendererData.childIndex, specialScriptLayoutResults);
                        childPos = lastFittingChildRendererData.childIndex;
                        childResult = lastFittingChildRendererData.childLayoutResult;
                        specialScriptLayoutResults.put(childPos, childResult);
                        MinMaxWidth textSequenceElemminMaxWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth();
                        minChildWidth = textSequenceElemminMaxWidth.getMinWidth();
                        maxChildWidth = textSequenceElemminMaxWidth.getMaxWidth();
                    }
                } else if (enableTextSequenceWrapping) {
                    boolean isOverflowFit = wasXOverflowChanged ? oldXOverflow == OverflowPropertyValue.FIT : LineRenderer.isOverflowFit((OverflowPropertyValue)((Object)this.getProperty(103)));
                    TextSequenceWordWrapping.LastFittingChildRendererData lastFittingChildRendererData = TextSequenceWordWrapping.getIndexAndLayoutResultOfTheLastTextRendererWithNoSpecialScripts(this, childPos, textRendererLayoutResults, wasParentsHeightClipped, isOverflowFit, floatsPlacedInLine || floatsPlacedBeforeLine);
                    if (lastFittingChildRendererData == null) {
                        textSequenceOverflowXProcessing = true;
                        shouldBreakLayouting = false;
                        firstChildToRelayout = childPos;
                    } else {
                        curWidth -= TextSequenceWordWrapping.getCurWidthRelayoutedTextSequenceDecrement(childPos, lastFittingChildRendererData.childIndex, textRendererLayoutResults);
                        childAscentDescent = this.updateAscentDescentAfterTextRendererSequenceProcessing(lastFittingChildRendererData.childLayoutResult.getStatus() == 3 ? lastFittingChildRendererData.childIndex - 1 : lastFittingChildRendererData.childIndex, lineAscentDescentStateBeforeTextRendererSequence, textRendererSequenceAscentDescent);
                        childPos = lastFittingChildRendererData.childIndex;
                        childResult = lastFittingChildRendererData.childLayoutResult;
                        if (0 == childPos && 3 == childResult.getStatus()) {
                            anythingPlaced = false;
                        }
                        textRendererLayoutResults.put(childPos, childResult);
                        MinMaxWidth textSequenceElemminMaxWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth();
                        minChildWidth = textSequenceElemminMaxWidth.getMinWidth();
                        maxChildWidth = textSequenceElemminMaxWidth.getMaxWidth();
                    }
                }
            }
            if (childPos != firstChildToRelayout) {
                float currChildTextIndent;
                if (!forceOverflowForTextRendererPartialResult) {
                    this.updateAscentDescentAfterChildLayout(childAscentDescent, childRenderer, isChildFloating);
                }
                float maxHeight = this.maxAscent - this.maxDescent;
                float f = currChildTextIndent = anythingPlaced ? 0.0f : lineLayoutContext.getTextIndent();
                if (hangingTabStop != null && (TabAlignment.LEFT == hangingTabStop.getTabAlignment() || shouldBreakLayouting || this.getChildRenderers().size() - 1 == childPos || this.getChildRenderers().get(childPos + 1) instanceof TabRenderer)) {
                    IRenderer tabRenderer = this.getChildRenderers().get(lastTabIndex);
                    ArrayList<IRenderer> affectedRenderers = new ArrayList<IRenderer>();
                    affectedRenderers.addAll(this.getChildRenderers().subList(lastTabIndex + 1, childPos + 1));
                    float tabWidth = this.calculateTab(layoutBox, curWidth, hangingTabStop, affectedRenderers, tabRenderer);
                    tabRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox), wasParentsHeightClipped));
                    float sumOfAffectedRendererWidths = 0.0f;
                    for (IRenderer renderer : affectedRenderers) {
                        renderer.move(tabWidth + sumOfAffectedRendererWidths, 0.0f);
                        sumOfAffectedRendererWidths += renderer.getOccupiedArea().getBBox().getWidth();
                    }
                    if (childResult.getSplitRenderer() != null) {
                        childResult.getSplitRenderer().move(tabWidth + sumOfAffectedRendererWidths - childResult.getSplitRenderer().getOccupiedArea().getBBox().getWidth(), 0.0f);
                    }
                    float tabAndNextElemWidth = tabWidth + childResult.getOccupiedArea().getBBox().getWidth();
                    curWidth = hangingTabStop.getTabAlignment() == TabAlignment.RIGHT && curWidth + tabAndNextElemWidth < hangingTabStop.getTabPosition() ? hangingTabStop.getTabPosition() : (curWidth += tabAndNextElemWidth);
                    widthHandler.updateMinChildWidth(minChildWidth + currChildTextIndent);
                    widthHandler.updateMaxChildWidth(tabWidth + maxChildWidth + currChildTextIndent);
                    hangingTabStop = null;
                } else if (null == hangingTabStop) {
                    if (childResult.getOccupiedArea() != null && childResult.getOccupiedArea().getBBox() != null) {
                        curWidth += childResult.getOccupiedArea().getBBox().getWidth();
                    }
                    widthHandler.updateMinChildWidth(minChildWidth + currChildTextIndent);
                    widthHandler.updateMaxChildWidth(maxChildWidth + currChildTextIndent);
                }
                if (!forceOverflowForTextRendererPartialResult) {
                    this.occupiedArea.setBBox(new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight() - maxHeight, curWidth, maxHeight));
                }
            }
            if (shouldBreakLayouting) {
                IRenderer causeOfNothing;
                LineRenderer[] split = this.split();
                split[0].setChildRenderers(this.getChildRenderers().subList(0, childPos));
                if (forceOverflowForTextRendererPartialResult) {
                    split[1].addChildRenderer(childRenderer);
                } else {
                    boolean isInlineBlockAndFirstOnRootArea;
                    boolean forcePlacement = Boolean.TRUE.equals(this.getPropertyAsBoolean(26));
                    boolean bl5 = isInlineBlockAndFirstOnRootArea = isInlineBlockChild && this.isFirstOnRootArea();
                    if (childResult.getStatus() == 2 && (!isInlineBlockChild || forcePlacement || isInlineBlockAndFirstOnRootArea) || childResult.getStatus() == 1) {
                        IRenderer splitRenderer = childResult.getSplitRenderer();
                        split[0].addChild(splitRenderer);
                        if (splitRenderer.getParent() != split[0] && split[0].childRenderers.contains(splitRenderer)) {
                            splitRenderer.setParent(split[0]);
                        }
                        anythingPlaced = true;
                    }
                    if (null != childResult.getOverflowRenderer()) {
                        if (isInlineBlockChild && !forcePlacement && !isInlineBlockAndFirstOnRootArea) {
                            split[1].addChildRenderer(childRenderer);
                        } else if (isInlineBlockChild && childResult.getOverflowRenderer().getChildRenderers().isEmpty() && childResult.getStatus() == 2) {
                            if (logger.isWarnEnabled()) {
                                logger.warn("Inline block element does not fit into parent element and will be clipped");
                            }
                        } else {
                            split[1].addChildRenderer(childResult.getOverflowRenderer());
                        }
                    }
                }
                split[1].addAllChildRenderers(this.getChildRenderers().subList(childPos + 1, this.getChildRenderers().size()));
                this.replaceSplitRendererKidFloats(floatsToNextPageSplitRenderers, split[0]);
                split[0].removeAllChildRenderers(floatsOverflowedToNextLine);
                split[1].addAllChildRenderers(0, floatsOverflowedToNextLine);
                if (split[1].getChildRenderers().isEmpty() && floatsToNextPageOverflowRenderers.isEmpty()) {
                    split[1] = null;
                }
                IRenderer iRenderer = causeOfNothing = childResult.getStatus() == 3 ? childResult.getCauseOfNothing() : this.getChildRenderers().get(childPos);
                result = split[1] == null ? new LineLayoutResult(1, this.occupiedArea, split[0], split[1], causeOfNothing) : (anythingPlaced || floatsPlacedInLine ? new LineLayoutResult(2, this.occupiedArea, split[0], split[1], causeOfNothing) : new LineLayoutResult(3, null, null, split[1], null));
                ((LineLayoutResult)result).setFloatsOverflowedToNextPage(floatsToNextPageOverflowRenderers);
                if (!newLineOccurred) break;
                ((LineLayoutResult)result).setSplitForcedByNewline(true);
                break;
            }
            if (childPos == firstChildToRelayout) {
                firstChildToRelayout = -1;
                continue;
            }
            anythingPlaced = true;
            ++childPos;
        }
        TextSequenceWordWrapping.resetTextSequenceIfItEnded(specialScriptLayoutResults, true, null, childPos, minMaxWidthOfTextRendererSequenceHelper, noSoftWrap, widthHandler);
        TextSequenceWordWrapping.resetTextSequenceIfItEnded(textRendererLayoutResults, false, null, childPos, minMaxWidthOfTextRendererSequenceHelper, noSoftWrap, widthHandler);
        if (result == null) {
            boolean noOverflowedFloats;
            boolean bl = noOverflowedFloats = floatsOverflowedToNextLine.isEmpty() && floatsToNextPageOverflowRenderers.isEmpty();
            if ((anythingPlaced || floatsPlacedInLine) && noOverflowedFloats || this.getChildRenderers().isEmpty()) {
                result = new LineLayoutResult(1, this.occupiedArea, null, null);
            } else if (noOverflowedFloats) {
                result = new LineLayoutResult(1, this.occupiedArea, null, null);
            } else if (anythingPlaced || floatsPlacedInLine) {
                LineRenderer[] split = this.split();
                split[0].addAllChildRenderers(this.getChildRenderers().subList(0, childPos));
                this.replaceSplitRendererKidFloats(floatsToNextPageSplitRenderers, split[0]);
                split[0].removeAllChildRenderers(floatsOverflowedToNextLine);
                split[1].addAllChildRenderers(floatsOverflowedToNextLine);
                result = new LineLayoutResult(2, this.occupiedArea, split[0], split[1], null);
                ((LineLayoutResult)result).setFloatsOverflowedToNextPage(floatsToNextPageOverflowRenderers);
            } else {
                IRenderer causeOfNothing = floatsOverflowedToNextLine.isEmpty() ? (IRenderer)floatsToNextPageOverflowRenderers.get(0) : (IRenderer)floatsOverflowedToNextLine.get(0);
                result = new LineLayoutResult(3, null, null, this, causeOfNothing);
            }
        }
        if ((toProcess = (LineRenderer)result.getSplitRenderer()) == null && result.getStatus() == 1) {
            toProcess = this;
        }
        if (baseDirection != null && baseDirection != BaseDirection.NO_BIDI && toProcess != null) {
            int[] newOrder;
            LineSplitIntoGlyphsData splitIntoGlyphsData = LineRenderer.splitLineIntoGlyphs(toProcess);
            byte[] lineLevels = new byte[splitIntoGlyphsData.getLineGlyphs().size()];
            if (this.levels != null) {
                System.arraycopy(this.levels, 0, lineLevels, 0, splitIntoGlyphsData.getLineGlyphs().size());
            }
            if ((newOrder = TypographyUtils.reorderLine(splitIntoGlyphsData.getLineGlyphs(), lineLevels, this.levels)) != null) {
                LineRenderer.reorder(toProcess, splitIntoGlyphsData, newOrder);
                LineRenderer.adjustChildPositionsAfterReordering(toProcess.getChildRenderers(), this.occupiedArea.getBBox().getLeft());
            }
            if (result.getStatus() == 2 && this.levels != null) {
                LineRenderer overflow = (LineRenderer)result.getOverflowRenderer();
                overflow.levels = new byte[this.levels.length - lineLevels.length];
                System.arraycopy(this.levels, lineLevels.length, overflow.levels, 0, overflow.levels.length);
                if (overflow.levels.length == 0) {
                    overflow.levels = null;
                }
            }
        }
        if (anythingPlaced || floatsPlacedInLine) {
            toProcess.adjustChildrenYLine().trimLast();
            ((MinMaxWidthLayoutResult)result).setMinMaxWidth(minMaxWidth);
        }
        if (wasXOverflowChanged) {
            this.setProperty(103, (Object)oldXOverflow);
            if (null != result.getSplitRenderer()) {
                result.getSplitRenderer().setProperty(103, (Object)oldXOverflow);
            }
            if (null != result.getOverflowRenderer()) {
                result.getOverflowRenderer().setProperty(103, (Object)oldXOverflow);
            }
        }
        return result;
    }

    public float getMaxAscent() {
        return this.maxAscent;
    }

    public float getMaxDescent() {
        return this.maxDescent;
    }

    public float getYLine() {
        return this.occupiedArea.getBBox().getY() - this.maxDescent;
    }

    public float getLeadingValue(Leading leading) {
        switch (leading.getType()) {
            case 1: {
                return Math.max(leading.getValue(), this.maxBlockAscent - this.maxBlockDescent);
            }
            case 2: {
                return this.getTopLeadingIndent(leading) + this.getBottomLeadingIndent(leading);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public IRenderer getNextRenderer() {
        return new LineRenderer();
    }

    @Override
    protected Float getFirstYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    @Override
    protected Float getLastYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    public void justify(float width) {
        int baseCharsCount;
        int numberOfSpaces;
        float ratio = this.getPropertyAsFloat(61).floatValue();
        IRenderer lastChildRenderer = this.getLastNonFloatChildRenderer();
        if (lastChildRenderer == null) {
            return;
        }
        float freeWidth = this.occupiedArea.getBBox().getX() + width - lastChildRenderer.getOccupiedArea().getBBox().getX() - lastChildRenderer.getOccupiedArea().getBBox().getWidth();
        float baseFactor = freeWidth / (ratio * (float)(numberOfSpaces = this.getNumberOfSpaces()) + (1.0f - ratio) * (float)((baseCharsCount = this.baseCharactersCount()) - 1));
        if (Float.isInfinite(baseFactor)) {
            baseFactor = 0.0f;
        }
        float wordSpacing = ratio * baseFactor;
        float characterSpacing = (1.0f - ratio) * baseFactor;
        float lastRightPos = this.occupiedArea.getBBox().getX();
        for (IRenderer child : this.getChildRenderers()) {
            if (FloatingHelper.isRendererFloating(child)) continue;
            float childX = child.getOccupiedArea().getBBox().getX();
            child.move(lastRightPos - childX, 0.0f);
            childX = lastRightPos;
            if (child instanceof TextRenderer) {
                float childHSCale = ((TextRenderer)child).getPropertyAsFloat(29, Float.valueOf(1.0f)).floatValue();
                Float oldCharacterSpacing = ((TextRenderer)child).getPropertyAsFloat(15);
                Float oldWordSpacing = ((TextRenderer)child).getPropertyAsFloat(78);
                child.setProperty(15, Float.valueOf((null == oldCharacterSpacing ? 0.0f : oldCharacterSpacing.floatValue()) + characterSpacing / childHSCale));
                child.setProperty(78, Float.valueOf((null == oldWordSpacing ? 0.0f : oldWordSpacing.floatValue()) + wordSpacing / childHSCale));
                boolean isLastTextRenderer = child == lastChildRenderer;
                float widthAddition = (float)(isLastTextRenderer ? ((TextRenderer)child).lineLength() - 1 : ((TextRenderer)child).lineLength()) * characterSpacing + wordSpacing * (float)((TextRenderer)child).getNumberOfSpaces();
                child.getOccupiedArea().getBBox().setWidth(child.getOccupiedArea().getBBox().getWidth() + widthAddition);
            }
            lastRightPos = childX + child.getOccupiedArea().getBBox().getWidth();
        }
        this.getOccupiedArea().getBBox().setWidth(width);
    }

    protected int getNumberOfSpaces() {
        int spaces = 0;
        for (IRenderer child : this.getChildRenderers()) {
            if (!(child instanceof TextRenderer) || FloatingHelper.isRendererFloating(child)) continue;
            spaces += ((TextRenderer)child).getNumberOfSpaces();
        }
        return spaces;
    }

    protected int length() {
        int length = 0;
        for (IRenderer child : this.getChildRenderers()) {
            if (!(child instanceof TextRenderer) || FloatingHelper.isRendererFloating(child)) continue;
            length += ((TextRenderer)child).lineLength();
        }
        return length;
    }

    protected int baseCharactersCount() {
        int count = 0;
        for (IRenderer child : this.getChildRenderers()) {
            if (!(child instanceof TextRenderer) || FloatingHelper.isRendererFloating(child)) continue;
            count += ((TextRenderer)child).baseCharactersCount();
        }
        return count;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRenderer renderer : this.getChildRenderers()) {
            sb.append(renderer.toString());
        }
        return sb.toString();
    }

    protected LineRenderer createSplitRenderer() {
        return (LineRenderer)this.getNextRenderer();
    }

    protected LineRenderer createOverflowRenderer() {
        return (LineRenderer)this.getNextRenderer();
    }

    protected LineRenderer[] split() {
        LineRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.occupiedArea = this.occupiedArea.clone();
        splitRenderer.parent = this.parent;
        splitRenderer.maxAscent = this.maxAscent;
        splitRenderer.maxDescent = this.maxDescent;
        splitRenderer.maxTextAscent = this.maxTextAscent;
        splitRenderer.maxTextDescent = this.maxTextDescent;
        splitRenderer.maxBlockAscent = this.maxBlockAscent;
        splitRenderer.maxBlockDescent = this.maxBlockDescent;
        splitRenderer.levels = this.levels;
        splitRenderer.addAllProperties(this.getOwnProperties());
        LineRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        return new LineRenderer[]{splitRenderer, overflowRenderer};
    }

    protected LineRenderer adjustChildrenYLine() {
        float actualYLine = this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.maxAscent;
        for (IRenderer renderer : this.getChildRenderers()) {
            if (FloatingHelper.isRendererFloating(renderer)) continue;
            if (renderer instanceof ILeafElementRenderer) {
                float descent = ((ILeafElementRenderer)renderer).getDescent();
                renderer.move(0.0f, actualYLine - renderer.getOccupiedArea().getBBox().getBottom() + descent);
                continue;
            }
            Float yLine = LineRenderer.isInlineBlockChild(renderer) && renderer instanceof AbstractRenderer ? ((AbstractRenderer)renderer).getLastYLineRecursively() : null;
            renderer.move(0.0f, actualYLine - (yLine == null ? renderer.getOccupiedArea().getBBox().getBottom() : yLine.floatValue()));
        }
        return this;
    }

    protected void applyLeading(float deltaY) {
        this.occupiedArea.getBBox().moveUp(deltaY);
        this.occupiedArea.getBBox().decreaseHeight(deltaY);
        for (IRenderer child : this.getChildRenderers()) {
            if (FloatingHelper.isRendererFloating(child)) continue;
            child.move(0.0f, deltaY);
        }
    }

    protected LineRenderer trimLast() {
        int lastIndex = this.getChildRenderers().size();
        IRenderer lastRenderer = null;
        while (--lastIndex >= 0 && FloatingHelper.isRendererFloating(lastRenderer = this.getChildRenderers().get(lastIndex))) {
        }
        if (lastRenderer instanceof TextRenderer && lastIndex >= 0) {
            float trimmedSpace = ((TextRenderer)lastRenderer).trimLast();
            this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() - trimmedSpace);
        }
        return this;
    }

    public boolean containsImage() {
        for (IRenderer renderer : this.getChildRenderers()) {
            if (!(renderer instanceof ImageRenderer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MinMaxWidth getMinMaxWidth() {
        LineLayoutResult result = (LineLayoutResult)this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(MinMaxWidthUtils.getInfWidth(), 1000000.0f))));
        return result.getMinMaxWidth();
    }

    boolean hasChildRendererInHtmlMode() {
        for (IRenderer childRenderer : this.getChildRenderers()) {
            if (!RenderingMode.HTML_MODE.equals(childRenderer.getProperty(123))) continue;
            return true;
        }
        return false;
    }

    float getTopLeadingIndent(Leading leading) {
        switch (leading.getType()) {
            case 1: {
                return (Math.max(leading.getValue(), this.maxBlockAscent - this.maxBlockDescent) - this.occupiedArea.getBBox().getHeight()) / 2.0f;
            }
            case 2: {
                UnitValue fontSize = this.getProperty(24, UnitValue.createPointValue(0.0f));
                if (!fontSize.isPointValue()) {
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
                }
                float textAscent = this.maxTextAscent == 0.0f && this.maxTextDescent == 0.0f && Math.abs(this.maxAscent) + Math.abs(this.maxDescent) != 0.0f && !this.containsImage() ? fontSize.getValue() * 0.8f : this.maxTextAscent;
                float textDescent = this.maxTextAscent == 0.0f && this.maxTextDescent == 0.0f && Math.abs(this.maxAscent) + Math.abs(this.maxDescent) != 0.0f && !this.containsImage() ? -fontSize.getValue() * 0.2f : this.maxTextDescent;
                return Math.max(textAscent + (textAscent - textDescent) * (leading.getValue() - 1.0f) / 2.0f, this.maxBlockAscent) - this.maxAscent;
            }
        }
        throw new IllegalStateException();
    }

    float getBottomLeadingIndent(Leading leading) {
        switch (leading.getType()) {
            case 1: {
                return (Math.max(leading.getValue(), this.maxBlockAscent - this.maxBlockDescent) - this.occupiedArea.getBBox().getHeight()) / 2.0f;
            }
            case 2: {
                UnitValue fontSize = this.getProperty(24, UnitValue.createPointValue(0.0f));
                if (!fontSize.isPointValue()) {
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
                }
                float textAscent = this.maxTextAscent == 0.0f && this.maxTextDescent == 0.0f && !this.containsImage() ? fontSize.getValue() * 0.8f : this.maxTextAscent;
                float textDescent = this.maxTextAscent == 0.0f && this.maxTextDescent == 0.0f && !this.containsImage() ? -fontSize.getValue() * 0.2f : this.maxTextDescent;
                return Math.max(-textDescent + (textAscent - textDescent) * (leading.getValue() - 1.0f) / 2.0f, -this.maxBlockDescent) + this.maxDescent;
            }
        }
        throw new IllegalStateException();
    }

    static LineSplitIntoGlyphsData splitLineIntoGlyphs(LineRenderer toSplit) {
        LineSplitIntoGlyphsData result = new LineSplitIntoGlyphsData();
        boolean newLineFound = false;
        TextRenderer lastTextRenderer = null;
        for (IRenderer child : toSplit.getChildRenderers()) {
            if (newLineFound) break;
            if (child instanceof TextRenderer) {
                GlyphLine childLine = ((TextRenderer)child).line;
                for (int i = childLine.start; i < childLine.end; ++i) {
                    if (TextUtil.isNewLine((Glyph)childLine.get(i))) {
                        newLineFound = true;
                        break;
                    }
                    result.addLineGlyph(new RendererGlyph(childLine.get(i), (TextRenderer)child));
                }
                lastTextRenderer = (TextRenderer)child;
                continue;
            }
            result.addInsertAfter(lastTextRenderer, child);
        }
        return result;
    }

    static void reorder(LineRenderer toProcess, LineSplitIntoGlyphsData splitLineIntoGlyphsResult, int[] newOrder) {
        int initialPos;
        toProcess.setChildRenderers(splitLineIntoGlyphsResult.getStarterNonTextRenderers());
        List<RendererGlyph> lineGlyphs = splitLineIntoGlyphsResult.getLineGlyphs();
        int offset = initialPos = 0;
        while (offset < lineGlyphs.size()) {
            TextRenderer renderer = lineGlyphs.get((int)offset).renderer;
            TextRenderer newRenderer = new TextRenderer(renderer).removeReversedRanges();
            toProcess.addChildRenderer(newRenderer);
            toProcess.addAllChildRenderers(splitLineIntoGlyphsResult.getInsertAfterAndRemove(renderer));
            newRenderer.line = new GlyphLine(newRenderer.line);
            ArrayList<Glyph> replacementGlyphs = new ArrayList<Glyph>();
            boolean reversed = false;
            for (int pos = offset; pos < lineGlyphs.size() && lineGlyphs.get((int)pos).renderer == renderer; ++pos) {
                replacementGlyphs.add(lineGlyphs.get((int)pos).glyph);
                if (pos + 1 < lineGlyphs.size() && lineGlyphs.get((int)(pos + 1)).renderer == renderer && newOrder[pos] == newOrder[pos + 1] + 1 && !TextUtil.isSpaceOrWhitespace((Glyph)lineGlyphs.get((int)(pos + 1)).glyph) && !TextUtil.isSpaceOrWhitespace((Glyph)lineGlyphs.get((int)pos).glyph)) {
                    reversed = true;
                    continue;
                }
                if (reversed) {
                    newRenderer.initReversedRanges().add(new int[]{initialPos - offset, pos - offset});
                    reversed = false;
                }
                initialPos = pos + 1;
            }
            newRenderer.line.setGlyphs(replacementGlyphs);
            offset = initialPos;
        }
    }

    static void adjustChildPositionsAfterReordering(List<IRenderer> children, float initialXPos) {
        float currentXPos = initialXPos;
        for (IRenderer child : children) {
            float currentWidth;
            if (FloatingHelper.isRendererFloating(child)) continue;
            if (child instanceof TextRenderer) {
                UnitValue[] paddings;
                currentWidth = ((TextRenderer)child).calculateLineWidth();
                UnitValue[] margins = ((TextRenderer)child).getMargins();
                if (!margins[1].isPointValue() && logger.isErrorEnabled()) {
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{"right margin"}));
                }
                if (!margins[3].isPointValue() && logger.isErrorEnabled()) {
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{"left margin"}));
                }
                if (!(paddings = ((TextRenderer)child).getPaddings())[1].isPointValue() && logger.isErrorEnabled()) {
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{"right padding"}));
                }
                if (!paddings[3].isPointValue() && logger.isErrorEnabled()) {
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{"left padding"}));
                }
                ((TextRenderer)child).occupiedArea.getBBox().setX(currentXPos).setWidth(currentWidth += margins[1].getValue() + margins[3].getValue() + paddings[1].getValue() + paddings[3].getValue());
            } else {
                currentWidth = child.getOccupiedArea().getBBox().getWidth();
                child.move(currentXPos - child.getOccupiedArea().getBBox().getX(), 0.0f);
            }
            currentXPos += currentWidth;
        }
    }

    private LineRenderer[] splitNotFittingFloat(int childPos, LayoutResult childResult) {
        LineRenderer[] split = this.split();
        split[0].addAllChildRenderers(this.getChildRenderers().subList(0, childPos));
        split[0].addChildRenderer(childResult.getSplitRenderer());
        split[1].addChildRenderer(childResult.getOverflowRenderer());
        split[1].addAllChildRenderers(this.getChildRenderers().subList(childPos + 1, this.getChildRenderers().size()));
        return split;
    }

    private void adjustLineOnFloatPlaced(Rectangle layoutBox, int childPos, FloatPropertyValue kidFloatPropertyVal, Rectangle justPlacedFloatBox) {
        if (justPlacedFloatBox.getBottom() >= layoutBox.getTop() || justPlacedFloatBox.getTop() < layoutBox.getTop()) {
            return;
        }
        float floatWidth = justPlacedFloatBox.getWidth();
        if (kidFloatPropertyVal.equals((Object)FloatPropertyValue.LEFT)) {
            layoutBox.setWidth(layoutBox.getWidth() - floatWidth).moveRight(floatWidth);
            this.occupiedArea.getBBox().moveRight(floatWidth);
            for (int i = 0; i < childPos; ++i) {
                IRenderer prevChild = this.getChildRenderers().get(i);
                if (FloatingHelper.isRendererFloating(prevChild)) continue;
                prevChild.move(floatWidth, 0.0f);
            }
        } else {
            layoutBox.setWidth(layoutBox.getWidth() - floatWidth);
        }
    }

    private void replaceSplitRendererKidFloats(Map<Integer, IRenderer> floatsToNextPageSplitRenderers, LineRenderer splitRenderer) {
        for (Map.Entry<Integer, IRenderer> splitFloat : floatsToNextPageSplitRenderers.entrySet()) {
            if (splitFloat.getValue() != null) {
                splitRenderer.setChildRenderer(splitFloat.getKey(), splitFloat.getValue());
                continue;
            }
            splitRenderer.setChildRenderer(splitFloat.getKey(), null);
        }
        for (int i = splitRenderer.getChildRenderers().size() - 1; i >= 0; --i) {
            if (splitRenderer.getChildRenderers().get(i) != null) continue;
            splitRenderer.removeChildRenderer(i);
        }
    }

    private IRenderer getLastNonFloatChildRenderer() {
        IRenderer result = null;
        for (int i = this.getChildRenderers().size() - 1; i >= 0; --i) {
            IRenderer current = this.getChildRenderers().get(i);
            if (FloatingHelper.isRendererFloating(current)) continue;
            result = current;
            break;
        }
        return result;
    }

    private TabStop getNextTabStop(float curWidth) {
        NavigableMap tabStops = (NavigableMap)this.getProperty(69);
        Map.Entry nextTabStopEntry = null;
        TabStop nextTabStop = null;
        if (tabStops != null) {
            nextTabStopEntry = tabStops.higherEntry(Float.valueOf(curWidth));
        }
        if (nextTabStopEntry != null) {
            nextTabStop = (TabStop)nextTabStopEntry.getValue();
        }
        return nextTabStop;
    }

    private TabStop calculateTab(IRenderer childRenderer, float curWidth, float lineWidth) {
        TabStop nextTabStop = this.getNextTabStop(curWidth);
        if (nextTabStop == null) {
            this.processDefaultTab(childRenderer, curWidth, lineWidth);
            return null;
        }
        childRenderer.setProperty(68, nextTabStop.getTabLeader());
        childRenderer.setProperty(77, UnitValue.createPointValue(nextTabStop.getTabPosition() - curWidth));
        childRenderer.setProperty(85, UnitValue.createPointValue(this.maxAscent - this.maxDescent));
        if (nextTabStop.getTabAlignment() == TabAlignment.LEFT) {
            return null;
        }
        return nextTabStop;
    }

    private float calculateTab(Rectangle layoutBox, float curWidth, TabStop tabStop, List<IRenderer> affectedRenderers, IRenderer tabRenderer) {
        float sumOfAffectedRendererWidths = 0.0f;
        for (IRenderer renderer : affectedRenderers) {
            sumOfAffectedRendererWidths += renderer.getOccupiedArea().getBBox().getWidth();
        }
        float tabWidth = 0.0f;
        switch (tabStop.getTabAlignment()) {
            case RIGHT: {
                tabWidth = tabStop.getTabPosition() - curWidth - sumOfAffectedRendererWidths;
                break;
            }
            case CENTER: {
                tabWidth = tabStop.getTabPosition() - curWidth - sumOfAffectedRendererWidths / 2.0f;
                break;
            }
            case ANCHOR: {
                IRenderer renderer;
                float anchorPosition = -1.0f;
                float processedRenderersWidth = 0.0f;
                Iterator<IRenderer> iterator = affectedRenderers.iterator();
                while (iterator.hasNext() && -1.0f == (anchorPosition = ((TextRenderer)(renderer = iterator.next())).getTabAnchorCharacterPosition())) {
                    processedRenderersWidth += renderer.getOccupiedArea().getBBox().getWidth();
                }
                if (anchorPosition == -1.0f) {
                    anchorPosition = 0.0f;
                }
                tabWidth = tabStop.getTabPosition() - curWidth - anchorPosition - processedRenderersWidth;
            }
        }
        if (tabWidth < 0.0f) {
            tabWidth = 0.0f;
        }
        if (curWidth + tabWidth + sumOfAffectedRendererWidths > layoutBox.getWidth()) {
            tabWidth -= curWidth + sumOfAffectedRendererWidths + tabWidth - layoutBox.getWidth();
        }
        tabRenderer.setProperty(77, UnitValue.createPointValue(tabWidth));
        tabRenderer.setProperty(85, UnitValue.createPointValue(this.maxAscent - this.maxDescent));
        return tabWidth;
    }

    private void processDefaultTab(IRenderer tabRenderer, float curWidth, float lineWidth) {
        Float tabDefault = this.getPropertyAsFloat(67);
        Float tabWidth = Float.valueOf(tabDefault.floatValue() - curWidth % tabDefault.floatValue());
        if (curWidth + tabWidth.floatValue() > lineWidth) {
            tabWidth = Float.valueOf(lineWidth - curWidth);
        }
        tabRenderer.setProperty(77, UnitValue.createPointValue(tabWidth.floatValue()));
        tabRenderer.setProperty(85, UnitValue.createPointValue(this.maxAscent - this.maxDescent));
    }

    private void updateChildrenParent() {
        for (IRenderer renderer : this.getChildRenderers()) {
            renderer.setParent(this);
        }
    }

    int trimFirst() {
        int totalNumberOfTrimmedGlyphs = 0;
        for (IRenderer renderer : this.getChildRenderers()) {
            boolean trimFinished;
            if (FloatingHelper.isRendererFloating(renderer)) continue;
            if (renderer instanceof TextRenderer) {
                TextRenderer textRenderer = (TextRenderer)renderer;
                GlyphLine currentText = textRenderer.getText();
                if (currentText != null) {
                    int prevTextStart = currentText.start;
                    textRenderer.trimFirst();
                    int numOfTrimmedGlyphs = textRenderer.getText().start - prevTextStart;
                    totalNumberOfTrimmedGlyphs += numOfTrimmedGlyphs;
                }
                trimFinished = textRenderer.length() > 0;
            } else {
                trimFinished = true;
            }
            if (!trimFinished) continue;
            break;
        }
        return totalNumberOfTrimmedGlyphs;
    }

    private BaseDirection applyOtf() {
        BaseDirection baseDirection = (BaseDirection)((Object)this.getProperty(7));
        for (IRenderer renderer : this.getChildRenderers()) {
            if (!(renderer instanceof TextRenderer)) continue;
            ((TextRenderer)renderer).applyOtf();
            if (baseDirection != null && baseDirection != BaseDirection.NO_BIDI) continue;
            baseDirection = (BaseDirection)((Object)renderer.getOwnProperty(7));
        }
        return baseDirection;
    }

    static boolean isChildFloating(IRenderer childRenderer) {
        FloatPropertyValue kidFloatPropertyVal = (FloatPropertyValue)((Object)childRenderer.getProperty(99));
        return childRenderer instanceof AbstractRenderer && FloatingHelper.isRendererFloating(childRenderer, kidFloatPropertyVal);
    }

    static boolean isInlineBlockChild(IRenderer child) {
        return child instanceof BlockRenderer || child instanceof TableRenderer;
    }

    boolean isForceOverflowForTextRendererPartialResult(IRenderer childRenderer, boolean wasXOverflowChanged, OverflowPropertyValue oldXOverflow, LayoutContext layoutContext, Rectangle layoutBox, boolean wasParentsHeightClipped) {
        if (wasXOverflowChanged) {
            this.setProperty(103, (Object)oldXOverflow);
        }
        LayoutResult newLayoutResult = childRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), layoutBox), wasParentsHeightClipped));
        if (wasXOverflowChanged) {
            this.setProperty(103, (Object)OverflowPropertyValue.FIT);
        }
        return newLayoutResult instanceof TextLayoutResult && !((TextLayoutResult)newLayoutResult).isWordHasBeenSplit();
    }

    float[] getAscentDescentOfLayoutedChildRenderer(IRenderer childRenderer, LayoutResult childResult, RenderingMode childRenderingMode, boolean isInlineBlockChild) {
        float childAscent = 0.0f;
        float childDescent = 0.0f;
        if (childRenderer instanceof ILeafElementRenderer && childResult.getStatus() != 3) {
            if (RenderingMode.HTML_MODE == childRenderingMode && childRenderer instanceof TextRenderer) {
                return LineHeightHelper.getActualAscenderDescender((TextRenderer)childRenderer);
            }
            childAscent = ((ILeafElementRenderer)childRenderer).getAscent();
            childDescent = ((ILeafElementRenderer)childRenderer).getDescent();
        } else if (isInlineBlockChild && childResult.getStatus() != 3) {
            if (childRenderer instanceof AbstractRenderer) {
                Float yLine = ((AbstractRenderer)childRenderer).getLastYLineRecursively();
                if (yLine == null) {
                    childAscent = childRenderer.getOccupiedArea().getBBox().getHeight();
                } else {
                    childAscent = childRenderer.getOccupiedArea().getBBox().getTop() - yLine.floatValue();
                    childDescent = -(yLine.floatValue() - childRenderer.getOccupiedArea().getBBox().getBottom());
                }
            } else {
                childAscent = childRenderer.getOccupiedArea().getBBox().getHeight();
            }
        }
        return new float[]{childAscent, childDescent};
    }

    float[] updateAscentDescentAfterTextRendererSequenceProcessing(int newChildPos, LineAscentDescentState lineAscentDescentStateBeforeTextRendererSequence, Map<Integer, float[]> textRendererSequenceAscentDescent) {
        float maxAscentUpdated = lineAscentDescentStateBeforeTextRendererSequence.maxAscent;
        float maxDescentUpdated = lineAscentDescentStateBeforeTextRendererSequence.maxDescent;
        float maxTextAscentUpdated = lineAscentDescentStateBeforeTextRendererSequence.maxTextAscent;
        float maxTextDescentUpdated = lineAscentDescentStateBeforeTextRendererSequence.maxTextDescent;
        for (Map.Entry<Integer, float[]> childAscentDescent : textRendererSequenceAscentDescent.entrySet()) {
            if (childAscentDescent.getKey() > newChildPos) continue;
            maxAscentUpdated = Math.max(maxAscentUpdated, childAscentDescent.getValue()[0]);
            maxDescentUpdated = Math.min(maxDescentUpdated, childAscentDescent.getValue()[1]);
            maxTextAscentUpdated = Math.max(maxTextAscentUpdated, childAscentDescent.getValue()[0]);
            maxTextDescentUpdated = Math.min(maxTextDescentUpdated, childAscentDescent.getValue()[1]);
        }
        this.maxAscent = maxAscentUpdated;
        this.maxDescent = maxDescentUpdated;
        this.maxTextAscent = maxTextAscentUpdated;
        this.maxTextDescent = maxTextDescentUpdated;
        return new float[]{this.maxAscent, this.maxDescent};
    }

    void updateAscentDescentAfterChildLayout(float[] childAscentDescent, IRenderer childRenderer, boolean isChildFloating) {
        float childAscent = childAscentDescent[0];
        float childDescent = childAscentDescent[1];
        this.maxAscent = Math.max(this.maxAscent, childAscent);
        if (childRenderer instanceof TextRenderer) {
            this.maxTextAscent = Math.max(this.maxTextAscent, childAscent);
        } else if (!isChildFloating) {
            this.maxBlockAscent = Math.max(this.maxBlockAscent, childAscent);
        }
        this.maxDescent = Math.min(this.maxDescent, childDescent);
        if (childRenderer instanceof TextRenderer) {
            this.maxTextDescent = Math.min(this.maxTextDescent, childDescent);
        } else if (!isChildFloating) {
            this.maxBlockDescent = Math.min(this.maxBlockDescent, childDescent);
        }
    }

    private void updateBidiLevels(int totalNumberOfTrimmedGlyphs, BaseDirection baseDirection) {
        if (totalNumberOfTrimmedGlyphs != 0 && this.levels != null) {
            this.levels = Arrays.copyOfRange(this.levels, totalNumberOfTrimmedGlyphs, this.levels.length);
        }
        ArrayList<Integer> unicodeIdsReorderingList = null;
        if (this.levels == null && baseDirection != null && baseDirection != BaseDirection.NO_BIDI) {
            unicodeIdsReorderingList = new ArrayList<Integer>();
            boolean newLineFound = false;
            block0: for (IRenderer child : this.getChildRenderers()) {
                if (newLineFound) break;
                if (!(child instanceof TextRenderer)) continue;
                GlyphLine text = ((TextRenderer)child).getText();
                for (int i = text.start; i < text.end; ++i) {
                    Glyph glyph = text.get(i);
                    if (TextUtil.isNewLine((Glyph)glyph)) {
                        newLineFound = true;
                        continue block0;
                    }
                    int unicode = glyph.hasValidUnicode() ? glyph.getUnicode() : glyph.getUnicodeChars()[0];
                    unicodeIdsReorderingList.add(unicode);
                }
            }
            if (unicodeIdsReorderingList.size() > 0) {
                PdfDocument pdfDocument = this.getPdfDocument();
                SequenceId sequenceId = pdfDocument == null ? null : pdfDocument.getDocumentIdWrapper();
                MetaInfoContainer metaInfoContainer = (MetaInfoContainer)this.getProperty(135);
                IMetaInfo metaInfo = metaInfoContainer == null ? null : metaInfoContainer.getMetaInfo();
                this.levels = TypographyUtils.getBidiLevels(baseDirection, ArrayUtil.toIntArray(unicodeIdsReorderingList), sequenceId, metaInfo);
            } else {
                this.levels = null;
            }
        }
    }

    private void resolveChildrenFonts() {
        ArrayList<IRenderer> newChildRenderers = new ArrayList<IRenderer>(this.getChildRenderers().size());
        boolean updateChildRenderers = false;
        for (IRenderer child : this.getChildRenderers()) {
            if (child instanceof TextRenderer) {
                if (!((TextRenderer)child).resolveFonts(newChildRenderers)) continue;
                updateChildRenderers = true;
                continue;
            }
            newChildRenderers.add(child);
        }
        if (updateChildRenderers) {
            this.setChildRenderers(newChildRenderers);
        }
    }

    private float decreaseRelativeWidthByChildAdditionalWidth(IRenderer childRenderer, float normalizedChildWidth) {
        if (childRenderer instanceof AbstractRenderer) {
            Rectangle dummyRect = new Rectangle(normalizedChildWidth, 0.0f);
            ((AbstractRenderer)childRenderer).applyMargins(dummyRect, false);
            if (!LineRenderer.isBorderBoxSizing(childRenderer)) {
                ((AbstractRenderer)childRenderer).applyBorderBox(dummyRect, false);
                ((AbstractRenderer)childRenderer).applyPaddings(dummyRect, false);
            }
            normalizedChildWidth = dummyRect.getWidth();
        }
        return normalizedChildWidth;
    }

    static class LineSplitIntoGlyphsData {
        private final List<RendererGlyph> lineGlyphs = new ArrayList<RendererGlyph>();
        private final Map<TextRenderer, List<IRenderer>> insertAfter = new HashMap<TextRenderer, List<IRenderer>>();
        private final List<IRenderer> starterNonTextRenderers = new ArrayList<IRenderer>();

        public List<RendererGlyph> getLineGlyphs() {
            return this.lineGlyphs;
        }

        public List<IRenderer> getInsertAfterAndRemove(TextRenderer afterRenderer) {
            return this.insertAfter.remove(afterRenderer);
        }

        public List<IRenderer> getStarterNonTextRenderers() {
            return this.starterNonTextRenderers;
        }

        public void addLineGlyph(RendererGlyph glyph) {
            this.lineGlyphs.add(glyph);
        }

        public void addInsertAfter(TextRenderer afterRenderer, IRenderer toInsert) {
            if (afterRenderer == null) {
                this.starterNonTextRenderers.add(toInsert);
            } else {
                if (!this.insertAfter.containsKey(afterRenderer)) {
                    this.insertAfter.put(afterRenderer, new ArrayList());
                }
                this.insertAfter.get(afterRenderer).add(toInsert);
            }
        }
    }

    static class LineAscentDescentState {
        float maxAscent;
        float maxDescent;
        float maxTextAscent;
        float maxTextDescent;

        LineAscentDescentState(float maxAscent, float maxDescent, float maxTextAscent, float maxTextDescent) {
            this.maxAscent = maxAscent;
            this.maxDescent = maxDescent;
            this.maxTextAscent = maxTextAscent;
            this.maxTextDescent = maxTextDescent;
        }
    }

    public static class RendererGlyph {
        public Glyph glyph;
        public TextRenderer renderer;

        public RendererGlyph(Glyph glyph, TextRenderer textRenderer) {
            this.glyph = glyph;
            this.renderer = textRenderer;
        }
    }
}

