/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.TextField;
import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.type.PdfFieldTypeEnum;
import net.sf.jasperreports.export.pdf.PdfTextField;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfField;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfProducer;

public class ClassicPdfTextField
extends ClassicPdfField
implements PdfTextField {
    private TextField textField;
    private PdfFieldTypeEnum fieldType;

    public ClassicPdfTextField(ClassicPdfProducer pdfProducer, TextField textField, PdfFieldTypeEnum fieldType) {
        super(pdfProducer, (BaseField)textField);
        this.textField = textField;
        this.fieldType = fieldType;
    }

    @Override
    public void setEdit() {
        this.textField.setOptions(this.textField.getOptions() | 0x40000);
    }

    @Override
    public void setMultiline() {
        this.textField.setOptions(this.textField.getOptions() | 0x1000);
    }

    @Override
    public void add() {
        try {
            PdfFormField field = this.fieldType == PdfFieldTypeEnum.COMBO ? this.textField.getComboField() : (this.fieldType == PdfFieldTypeEnum.LIST ? this.textField.getListField() : this.textField.getTextField());
            this.pdfProducer.getPdfWriter().addAnnotation((PdfAnnotation)field);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        catch (DocumentException e) {
            throw new JRRuntimeException(e);
        }
    }
}

