/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.tabulator;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.PrintElementIndex;
import net.sf.jasperreports.engine.export.tabulator.BaseElementCell;
import net.sf.jasperreports.engine.export.tabulator.Cell;
import net.sf.jasperreports.engine.export.tabulator.CellVisitor;
import net.sf.jasperreports.engine.export.tabulator.Column;
import net.sf.jasperreports.engine.export.tabulator.DimensionEntry;
import net.sf.jasperreports.engine.export.tabulator.DimensionRange;
import net.sf.jasperreports.engine.export.tabulator.ElementCell;
import net.sf.jasperreports.engine.export.tabulator.FrameCell;
import net.sf.jasperreports.engine.export.tabulator.LayeredCell;
import net.sf.jasperreports.engine.export.tabulator.Row;
import net.sf.jasperreports.engine.export.tabulator.SplitCell;
import net.sf.jasperreports.engine.export.tabulator.Table;
import net.sf.jasperreports.engine.export.tabulator.TableCell;
import net.sf.jasperreports.engine.export.tabulator.TablePosition;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.Bounds;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Tabulator {
    private static final Log log = LogFactory.getLog(Tabulator.class);
    public static final String EXCEPTION_MESSAGE_KEY_DROPPING_PARENT_ERROR = "export.tabulator.dropping.parent.error";
    private final ExporterFilter filter;
    private final List<? extends JRPrintElement> elements;
    private Table mainTable;
    private ParentCheck parentCheck = new ParentCheck();
    private SpanRangeCheck spanRangeCheck = new SpanRangeCheck();
    private SpanCheck spanCheck = new SpanCheck();
    private CollapseCheck collapseCheck = new CollapseCheck();
    private TableCellCreator tableCellCreator = new TableCellCreator();

    public Tabulator(ExporterFilter filter, List<? extends JRPrintElement> elements) {
        this.filter = filter;
        this.elements = elements;
        this.mainTable = new Table(this);
    }

    public void tabulate() {
        this.layoutElements(this.elements, this.mainTable, null, null, 0, 0, null);
    }

    public void tabulate(int xOffset, int yOffset) {
        this.layoutElements(this.elements, this.mainTable, null, null, xOffset, yOffset, null);
    }

    protected void layoutElements(List<? extends JRPrintElement> elementList, Table table, FrameCell parentCell, PrintElementIndex parentIndex, int xOffset, int yOffset, Bounds elementBounds) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("laying out " + this.elements.size() + " elements for parent " + parentCell + " at offsets " + xOffset + ", " + yOffset));
        }
        ListIterator<? extends JRPrintElement> it = elementList.listIterator(elementList.size());
        while (it.hasPrevious()) {
            JRPrintElement element = it.previous();
            if (this.filter != null && !this.filter.isToExport(element)) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("element " + element.getUUID() + " skipped by filter " + element));
                continue;
            }
            if (element.getWidth() <= 0 || element.getHeight() <= 0) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("element " + element.getUUID() + " skipped, size " + element.getWidth() + ", " + element.getHeight()));
                continue;
            }
            if (elementBounds != null && !elementBounds.contains(element.getX(), element.getX() + element.getWidth(), element.getY(), element.getY() + element.getHeight())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("element " + element.getUUID() + " at [" + element.getX() + "," + (element.getX() + element.getWidth()) + "),[" + element.getY() + "," + (element.getY() + element.getHeight()) + ") does not fit inside bounds " + elementBounds));
                continue;
            }
            this.placeElement(table, parentCell, xOffset, yOffset, element, parentIndex, it.nextIndex(), true);
        }
    }

    protected boolean placeElement(Table table, FrameCell parentCell, int xOffset, int yOffset, JRPrintElement element, PrintElementIndex parentIndex, int elementIndex, boolean allowOverlap) {
        Bounds originalBounds;
        DimensionRange<Column> colRange = table.columns.getRange(element.getX() + xOffset, element.getX() + element.getWidth() + xOffset);
        DimensionRange<Row> rowRange = table.rows.getRange(element.getY() + yOffset, element.getY() + element.getHeight() + yOffset);
        if (log.isTraceEnabled()) {
            log.trace((Object)("placing element " + element.getUUID() + " at " + colRange.start + ", " + colRange.end + ", " + rowRange.start + ", " + rowRange.end));
        }
        boolean overlap = false;
        Bounds overlapBounds = new Bounds(colRange.start, colRange.end, rowRange.start, rowRange.end);
        JROrigin elementOrigin = element.getOrigin();
        if (parentCell == null && elementOrigin != null && elementOrigin.getReportName() == null && elementOrigin.getBandTypeValue() == BandTypeEnum.BACKGROUND) {
            SortedSet<Column> userColumns = table.columns.getUserEntries();
            SortedSet<Row> userRows = table.rows.getUserEntries();
            if (!userColumns.isEmpty() && !userRows.isEmpty()) {
                overlapBounds.grow(userColumns.first().startCoord, userColumns.last().endCoord, userRows.first().startCoord, userRows.last().endCoord);
            }
        }
        Bounds covered = null;
        block0: do {
            originalBounds = overlapBounds.cloneBounds();
            if (rowRange.start != overlapBounds.getStartY() || rowRange.end != overlapBounds.getEndY()) {
                rowRange = table.rows.getRange(overlapBounds.getStartY(), overlapBounds.getEndY());
            }
            if (colRange.start != overlapBounds.getStartX() || colRange.end != overlapBounds.getEndX()) {
                colRange = table.columns.getRange(overlapBounds.getStartX(), overlapBounds.getEndX());
            }
            for (Row row : rowRange.rangeSet) {
                for (Column col : colRange.rangeSet) {
                    Cell cell;
                    if (covered != null && covered.contains(col.startCoord, col.endCoord, row.startCoord, row.endCoord) || this.canOverwrite(cell = row.getCell(col), parentCell)) continue;
                    overlap = true;
                    if (!allowOverlap) break block0;
                    Cell overlapParentCell = this.overlapParentCell(cell, parentCell);
                    Pair<Column, Column> colSpanRange = this.getColumnSpanRange(table, col, row, overlapParentCell);
                    Pair<Row, Row> rowSpanRange = this.getRowSpanRange(table, col, row, overlapParentCell);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("found overlap with cell " + cell + ", overlap parent " + overlapParentCell + ", column span range " + colSpanRange.first().startCoord + " to " + colSpanRange.second().startCoord + ", row span range " + rowSpanRange.first().startCoord + " to " + rowSpanRange.second().startCoord));
                    }
                    overlapBounds.grow(colSpanRange.first().startCoord, colSpanRange.second().startCoord, rowSpanRange.first().startCoord, rowSpanRange.second().startCoord);
                }
            }
            covered = originalBounds;
        } while (!originalBounds.equals(overlapBounds));
        if (!overlap) {
            this.setElementCells(table, parentCell, xOffset, yOffset, element, parentIndex, elementIndex, colRange, rowRange);
            return true;
        }
        if (!allowOverlap) {
            return false;
        }
        this.placeOverlappedElement(table, parentCell, xOffset, yOffset, element, parentIndex, elementIndex, overlapBounds);
        return true;
    }

    protected void placeOverlappedElement(Table table, FrameCell parentCell, int xOffset, int yOffset, JRPrintElement element, PrintElementIndex parentIndex, int elementIndex, Bounds overlapBounds) {
        DimensionRange<Column> overlapColRange = table.columns.getRange(overlapBounds.getStartX(), overlapBounds.getEndX());
        DimensionRange<Row> overlapRowRange = table.rows.getRange(overlapBounds.getStartY(), overlapBounds.getEndY());
        DimensionRange<Column> layeredColRange = table.columns.addEntries(overlapColRange);
        DimensionRange<Row> layeredRowRange = table.rows.addEntries(overlapRowRange);
        boolean placed = false;
        Cell firstOverlapCell = ((Row)overlapRowRange.floor).getCell((Column)overlapColRange.floor);
        if (firstOverlapCell instanceof LayeredCell) {
            LayeredCell layeredCell = (LayeredCell)firstOverlapCell;
            Column lastCol = table.columns.getEntries().lower((Column)layeredColRange.ceiling);
            Row lastRow = table.rows.getEntries().lower((Row)layeredRowRange.ceiling);
            Cell lastCell = lastRow.getCell(lastCol);
            if (lastCell != null && (layeredCell.equals(lastCell) || layeredCell.accept(this.spanCheck, lastCell).booleanValue())) {
                placed = true;
                this.placeInLayeredCell(xOffset, yOffset, element, parentIndex, elementIndex, layeredCell, layeredColRange, layeredRowRange);
            }
        }
        if (!placed) {
            this.createLayeredCell(table, parentCell, xOffset, yOffset, element, parentIndex, elementIndex, layeredColRange, layeredRowRange);
        }
    }

    protected void placeInLayeredCell(int xOffset, int yOffset, JRPrintElement element, PrintElementIndex parentIndex, int elementIndex, LayeredCell layeredCell, DimensionRange<Column> layeredColRange, DimensionRange<Row> layeredRowRange) {
        Table firstLayer = layeredCell.getLayers().get(0);
        boolean placed = this.placeElement(firstLayer, null, xOffset - layeredColRange.start, yOffset - layeredRowRange.start, element, parentIndex, elementIndex, false);
        if (placed) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("placed element on first layer of " + layeredCell));
            }
        } else {
            this.createOverlappedLayer(xOffset, yOffset, layeredCell, element, parentIndex, elementIndex, layeredColRange, layeredRowRange);
        }
    }

    protected void createLayeredCell(Table table, FrameCell parentCell, int xOffset, int yOffset, JRPrintElement element, PrintElementIndex parentIndex, int elementIndex, DimensionRange<Column> layeredColRange, DimensionRange<Row> layeredRowRange) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("creating layered cell at " + layeredColRange + ", " + layeredRowRange));
        }
        LayeredCell layeredCell = new LayeredCell(parentCell);
        Table firstLayer = new Table(this);
        layeredCell.addLayer(firstLayer);
        this.moveCellsToLayerTable(parentCell, firstLayer, layeredColRange, layeredRowRange);
        this.setElementCells(layeredColRange, layeredRowRange, layeredCell);
        this.collapseSpanColumns(table, layeredColRange);
        this.collapseSpanRows(table, layeredRowRange);
        this.createOverlappedLayer(xOffset, yOffset, layeredCell, element, parentIndex, elementIndex, layeredColRange, layeredRowRange);
    }

    protected void createOverlappedLayer(int xOffset, int yOffset, LayeredCell layeredCell, JRPrintElement element, PrintElementIndex parentIndex, int elementIndex, DimensionRange<Column> layeredColRange, DimensionRange<Row> layeredRowRange) {
        Table overlappedLayer = new Table(this);
        layeredCell.addLayer(overlappedLayer);
        overlappedLayer.columns.addEntry(0);
        overlappedLayer.columns.addEntry(layeredColRange.end - layeredColRange.start);
        overlappedLayer.rows.addEntry(0);
        int layerXOffset = xOffset - layeredColRange.start;
        int layerYOffset = yOffset - layeredRowRange.start;
        DimensionRange<Column> layerColRange = overlappedLayer.columns.getRange(element.getX() + layerXOffset, element.getX() + element.getWidth() + layerXOffset);
        DimensionRange<Row> layerRowRange = overlappedLayer.rows.getRange(element.getY() + layerYOffset, element.getY() + element.getHeight() + layerYOffset);
        this.setElementCells(overlappedLayer, null, layerXOffset, layerYOffset, element, parentIndex, elementIndex, layerColRange, layerRowRange);
    }

    protected void setElementCells(Table table, FrameCell parentCell, int xOffset, int yOffset, JRPrintElement element, PrintElementIndex parentIndex, int elementIndex, DimensionRange<Column> colRange, DimensionRange<Row> rowRange) {
        DimensionRange<Column> elementColRange = table.columns.addEntries(colRange);
        DimensionRange<Row> elementRowRange = table.rows.addEntries(rowRange);
        if (element instanceof JRPrintFrame) {
            JRPrintFrame frame = (JRPrintFrame)element;
            FrameCell frameCell = new FrameCell(parentCell, parentIndex, elementIndex);
            this.setElementCells(elementColRange, elementRowRange, frameCell);
            PrintElementIndex frameIndex = new PrintElementIndex(parentIndex, elementIndex);
            JRLineBox box = frame.getLineBox();
            this.layoutElements(frame.getElements(), table, frameCell, frameIndex, xOffset + frame.getX() + box.getLeftPadding(), yOffset + frame.getY() + box.getTopPadding(), new Bounds(0, frame.getWidth() - box.getLeftPadding() - box.getRightPadding(), 0, frame.getHeight() - box.getTopPadding() - box.getBottomPadding()));
        } else {
            ElementCell elementCell = new ElementCell(parentCell, parentIndex, elementIndex);
            this.setElementCells(elementColRange, elementRowRange, elementCell);
        }
    }

    protected boolean canOverwrite(Cell existingCell, FrameCell currentParent) {
        if (existingCell == null) {
            return true;
        }
        if (existingCell instanceof FrameCell) {
            return this.isParent((FrameCell)existingCell, currentParent);
        }
        return false;
    }

    protected boolean isParent(FrameCell parent, FrameCell child) {
        boolean foundAncestor = false;
        for (FrameCell ancestor = child; ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.equals(parent)) continue;
            foundAncestor = true;
            break;
        }
        return foundAncestor;
    }

    protected Cell overlapParentCell(Cell existingCell, FrameCell currentParent) {
        LinkedList<FrameCell> existingParents = new LinkedList<FrameCell>();
        for (FrameCell parent = existingCell.getParent(); parent != null; parent = parent.getParent()) {
            existingParents.addFirst(parent);
        }
        LinkedList<FrameCell> currentParents = new LinkedList<FrameCell>();
        for (FrameCell parent = currentParent; parent != null; parent = parent.getParent()) {
            currentParents.addFirst(parent);
        }
        Iterator existingIt = existingParents.iterator();
        Iterator currentIt = currentParents.iterator();
        while (existingIt.hasNext()) {
            FrameCell currentCell;
            FrameCell existingParent = (FrameCell)existingIt.next();
            FrameCell frameCell = currentCell = currentIt.hasNext() ? (FrameCell)currentIt.next() : null;
            if (currentCell != null && existingParent.equals(currentCell)) continue;
            return existingParent;
        }
        return existingCell;
    }

    protected Pair<Column, Column> getColumnSpanRange(Table table, Column col, Row row, Cell spanned) {
        Column headCol;
        Cell headCell;
        Column startCol = col;
        Iterator<Column> iterator = table.columns.getEntries().headSet(col, false).descendingSet().iterator();
        while (iterator.hasNext() && (headCell = row.getCell(headCol = iterator.next())) != null && spanned.accept(this.spanRangeCheck, headCell).booleanValue()) {
            startCol = headCol;
        }
        Column endCol = null;
        Iterator iterator2 = table.columns.getEntries().tailSet(col).iterator();
        while (iterator2.hasNext()) {
            Column tailCol;
            endCol = tailCol = (Column)iterator2.next();
            Cell tailCell = row.getCell(tailCol);
            if (tailCell != null && spanned.accept(this.spanRangeCheck, tailCell).booleanValue()) continue;
            break;
        }
        assert (endCol != null);
        assert (startCol.startCoord < endCol.startCoord);
        return new Pair<Column, Column>(startCol, endCol);
    }

    protected Pair<Row, Row> getRowSpanRange(Table table, Column col, Row row, Cell spanned) {
        Row headRow;
        Cell headCell;
        Row startRow = row;
        Iterator<Row> iterator = table.rows.getEntries().headSet(row, false).descendingSet().iterator();
        while (iterator.hasNext() && (headCell = (headRow = iterator.next()).getCell(col)) != null && spanned.accept(this.spanRangeCheck, headCell).booleanValue()) {
            startRow = headRow;
        }
        Row endRow = null;
        Iterator iterator2 = table.rows.getEntries().tailSet(row).iterator();
        while (iterator2.hasNext()) {
            Row tailRow;
            endRow = tailRow = (Row)iterator2.next();
            Cell tailCell = tailRow.getCell(col);
            if (tailCell != null && spanned.accept(this.spanRangeCheck, tailCell).booleanValue()) continue;
            break;
        }
        assert (endRow != null);
        assert (startRow.startCoord < endRow.startCoord);
        return new Pair<Row, Row>(startRow, endRow);
    }

    protected void moveCellsToLayerTable(FrameCell parentCell, Table layerTable, DimensionRange<Column> colRange, DimensionRange<Row> rowRange) {
        layerTable.columns.addEntry(0, colRange.end - colRange.start);
        layerTable.rows.addEntry(0, rowRange.end - rowRange.start);
        ParentDrop parentDrop = new ParentDrop();
        for (Row row : rowRange.rangeSet) {
            for (Column column : colRange.rangeSet) {
                Cell cell = row.getCell(column);
                Cell layerCell = cell == null ? null : cell.accept(parentDrop, parentCell);
                if (layerCell == null) continue;
                Column lastColSpan = (Column)this.getColumnCellSpan(colRange.rangeSet, (Column)column, (Row)row, (Cell)cell).lastEntry;
                Row lastRowSpan = (Row)this.getRowCellSpan(rowRange.rangeSet, (Column)column, (Row)row, (Cell)cell).lastEntry;
                DimensionRange<Column> cellColRange = layerTable.columns.getRange(column.startCoord - colRange.start, lastColSpan.endCoord - colRange.start);
                DimensionRange<Row> cellRowRange = layerTable.rows.getRange(row.startCoord - rowRange.start, lastRowSpan.endCoord - rowRange.start);
                DimensionRange<Column> cellFinalColRange = layerTable.columns.addEntries(cellColRange);
                DimensionRange<Row> cellFinalRowRange = layerTable.rows.addEntries(cellRowRange);
                this.setElementCells(cellFinalColRange, cellFinalRowRange, layerCell);
            }
        }
    }

    protected void collapseSpanColumns(Table table, DimensionRange<Column> range) {
        ArrayList<Pair<Column, Column>> removeList = new ArrayList<Pair<Column, Column>>();
        Column prevColumn = null;
        for (Column column : range.rangeSet) {
            if (prevColumn == null) {
                prevColumn = column;
                continue;
            }
            boolean collapse = true;
            for (Row row : table.getRows().getEntries()) {
                Cell prevCell = row.getCell(prevColumn);
                Cell cell = row.getCell(column);
                boolean collapseCell = prevCell == null ? cell == null : cell != null && prevCell.accept(this.collapseCheck, cell) != false;
                if (collapseCell) continue;
                collapse = false;
                break;
            }
            if (collapse) {
                removeList.add(new Pair<Column, Column>(column, prevColumn));
                continue;
            }
            prevColumn = column;
        }
        for (Pair pair : removeList) {
            table.removeColumn((Column)pair.first(), (Column)pair.second());
        }
    }

    protected void collapseSpanRows(Table table, DimensionRange<Row> range) {
        ArrayList<Pair<Row, Row>> removeList = new ArrayList<Pair<Row, Row>>();
        Row prevRow = null;
        for (Row row : range.rangeSet) {
            if (prevRow == null) {
                prevRow = row;
                continue;
            }
            boolean collapse = true;
            for (Column column : table.getColumns().getEntries()) {
                Cell prevCell = prevRow.getCell(column);
                Cell cell = row.getCell(column);
                boolean collapseCell = prevCell == null ? cell == null : cell != null && prevCell.accept(this.collapseCheck, cell) != false;
                if (collapseCell) continue;
                collapse = false;
                break;
            }
            if (collapse) {
                removeList.add(new Pair<Row, Row>(row, prevRow));
                continue;
            }
            prevRow = row;
        }
        for (Pair pair : removeList) {
            table.removeRow((Row)pair.first(), (Row)pair.second());
        }
    }

    protected void setElementCells(DimensionRange<Column> elementColRange, DimensionRange<Row> elementRowRange, Cell elementCell) {
        ((Row)elementRowRange.floor).setCell((Column)elementColRange.floor, elementCell);
        for (Column col : elementColRange.rangeSet.tailSet((Column)elementColRange.floor, false)) {
            ((Row)elementRowRange.floor).setCell(col, elementCell.split());
        }
        for (Row row : elementRowRange.rangeSet.tailSet((Row)elementRowRange.floor, false)) {
            for (Column col : elementColRange.rangeSet) {
                row.setCell(col, elementCell.split());
            }
        }
    }

    public void addMargins(int width, int height) {
        this.mainTable.columns.addMargins(width);
        this.mainTable.rows.addMargins(height);
    }

    protected Column columnKey(int startCoord) {
        return new Column(startCoord);
    }

    protected Row rowKey(int startCoord) {
        return new Row(startCoord);
    }

    protected void columnSplit(Table table, Column splitCol, Column newCol) {
        for (Row row : table.rows.getEntries()) {
            Cell cell = row.getCell(splitCol);
            if (cell == null) continue;
            Cell splitCell = cell.split();
            row.setCell(newCol, splitCell);
        }
    }

    protected void rowSplit(Table table, Row splitRow, Row newRow) {
        for (Column col : table.columns.getEntries()) {
            Cell cell = splitRow.getCell(col);
            if (cell == null) continue;
            Cell splitCell = cell.split();
            newRow.setCell(col, splitCell);
        }
    }

    protected boolean isSplitCell(Cell spanned, Cell cell) {
        return cell instanceof SplitCell && ((SplitCell)cell).getSourceCell().equals(spanned);
    }

    public Table getTable() {
        return this.mainTable;
    }

    public JRPrintElement getCellElement(BaseElementCell cell) {
        return this.getCellElement(cell.getParentIndex(), cell.getElementIndex());
    }

    protected JRPrintElement getCellElement(PrintElementIndex parentIndex, int index) {
        JRPrintElement element;
        if (parentIndex == null) {
            element = this.elements.get(index);
        } else {
            JRPrintFrame parentFrame = (JRPrintFrame)this.getCellElement(parentIndex.getParentIndex(), parentIndex.getIndex());
            element = parentFrame.getElements().get(index);
        }
        return element;
    }

    protected boolean isParent(FrameCell parent, Cell child) {
        if (child == null) {
            return false;
        }
        return child.accept(this.parentCheck, parent);
    }

    protected SpanInfo<Column> getColumnCellSpan(TablePosition position, Cell cell) {
        return this.getColumnCellSpan(position.getTable().columns.getEntries(), position.getColumn(), position.getRow(), cell);
    }

    protected SpanInfo<Column> getColumnCellSpan(NavigableSet<Column> columns, Column column, Row row, Cell cell) {
        Column tailCol;
        Cell tailCell;
        int span = 1;
        Column lastCol = column;
        Iterator<Column> iterator = columns.tailSet(column, false).iterator();
        while (iterator.hasNext() && (tailCell = row.getCell(tailCol = iterator.next())) != null && cell.accept(this.spanCheck, tailCell).booleanValue()) {
            ++span;
            lastCol = tailCol;
        }
        return new SpanInfo<Column>(span, lastCol);
    }

    protected SpanInfo<Row> getRowCellSpan(TablePosition position, Cell cell) {
        return this.getRowCellSpan(position.getTable().rows.getEntries(), position.getColumn(), position.getRow(), cell);
    }

    protected SpanInfo<Row> getRowCellSpan(NavigableSet<Row> rows, Column column, Row row, Cell cell) {
        Row tailRow;
        Cell tailCell;
        int span = 1;
        Row lastRow = row;
        Iterator<Row> iterator = rows.tailSet(row, false).iterator();
        while (iterator.hasNext() && (tailCell = (tailRow = iterator.next()).getCell(column)) != null && cell.accept(this.spanCheck, tailCell).booleanValue()) {
            ++span;
            lastRow = tailRow;
        }
        return new SpanInfo<Row>(span, lastRow);
    }

    protected FrameCell droppedParent(FrameCell existingParent, FrameCell parent) {
        if (existingParent == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_DROPPING_PARENT_ERROR, (Object[])null);
        }
        if (existingParent.equals(parent)) {
            return null;
        }
        FrameCell droppedGrandParent = this.droppedParent(existingParent.getParent(), parent);
        FrameCell droppedParent = new FrameCell(droppedGrandParent, existingParent.getParentIndex(), existingParent.getElementIndex());
        return droppedParent;
    }

    public TableCell getTableCell(TablePosition position, Cell cell) {
        return cell.accept(this.tableCellCreator, position);
    }

    protected static class SpanInfo<T extends DimensionEntry> {
        protected final int span;
        protected final T lastEntry;

        public SpanInfo(int span, T lastEntry) {
            this.span = span;
            this.lastEntry = lastEntry;
        }
    }

    protected class TableCellCreator
    implements CellVisitor<TablePosition, TableCell, RuntimeException> {
        protected TableCellCreator() {
        }

        @Override
        public TableCell visit(ElementCell cell, TablePosition position) {
            JRPrintElement element = Tabulator.this.getCellElement(cell);
            int colSpan = Tabulator.this.getColumnCellSpan((TablePosition)position, (Cell)cell).span;
            int rowSpan = Tabulator.this.getRowCellSpan((TablePosition)position, (Cell)cell).span;
            Color backcolor = this.getElementBackcolor(cell);
            JRLineBox elementBox = element instanceof JRBoxContainer ? ((JRBoxContainer)((Object)element)).getLineBox() : null;
            JRLineBox box = this.copyParentBox(cell, element, elementBox, true, true, true, true);
            TableCell tableCell = new TableCell(Tabulator.this, position, cell, element, colSpan, rowSpan, backcolor, box);
            return tableCell;
        }

        @Override
        public TableCell visit(SplitCell cell, TablePosition position) {
            return null;
        }

        @Override
        public TableCell visit(FrameCell frameCell, TablePosition position) {
            JRPrintElement element = Tabulator.this.getCellElement(frameCell);
            Color backcolor = this.getElementBackcolor(frameCell);
            boolean[] borders = this.getFrameCellBorders(position.getTable(), frameCell, position.getColumn(), position.getColumn(), position.getRow(), position.getRow());
            JRLineBox box = this.copyFrameBox(frameCell, (JRPrintFrame)element, null, borders[0], borders[1], borders[2], borders[3]);
            return new TableCell(Tabulator.this, position, frameCell, element, 1, 1, backcolor, box);
        }

        @Override
        public TableCell visit(LayeredCell layeredCell, TablePosition position) {
            boolean[] borders;
            SpanInfo<Column> colSpan = Tabulator.this.getColumnCellSpan(position, layeredCell);
            SpanInfo<Row> rowSpan = Tabulator.this.getRowCellSpan(position, layeredCell);
            Color backcolor = this.getElementBackcolor(layeredCell.getParent());
            JRLineBox box = null;
            FrameCell parentCell = layeredCell.getParent();
            if (parentCell != null && ((borders = this.getFrameCellBorders(position.getTable(), parentCell, position.getColumn(), (Column)colSpan.lastEntry, position.getRow(), (Row)rowSpan.lastEntry))[0] || borders[1] || borders[2] || borders[3])) {
                JRPrintFrame parentFrame = (JRPrintFrame)Tabulator.this.getCellElement(parentCell);
                box = this.copyFrameBox(parentCell, parentFrame, null, borders[0], borders[1], borders[2], borders[3]);
            }
            return new TableCell(Tabulator.this, position, layeredCell, null, colSpan.span, rowSpan.span, backcolor, box);
        }

        protected Color getElementBackcolor(BaseElementCell cell) {
            if (cell == null) {
                return null;
            }
            JRPrintElement element = Tabulator.this.getCellElement(cell);
            if (element.getModeValue() == ModeEnum.OPAQUE) {
                return element.getBackcolor();
            }
            return this.getElementBackcolor(cell.getParent());
        }

        protected JRLineBox copyParentBox(Cell cell, JRPrintElement element, JRLineBox baseBox, boolean keepLeft, boolean keepRight, boolean keepTop, boolean keepBottom) {
            FrameCell parentCell = cell.getParent();
            if (parentCell == null) {
                return baseBox;
            }
            JRPrintFrame parentFrame = (JRPrintFrame)Tabulator.this.getCellElement(parentCell);
            keepLeft &= element.getX() == 0 && parentFrame.getLineBox().getLeftPadding() == 0;
            keepRight &= element.getX() + element.getWidth() + parentFrame.getLineBox().getLeftPadding() == parentFrame.getWidth();
            JRLineBox resultBox = baseBox;
            if (keepLeft || keepRight || (keepTop &= element.getY() == 0 && parentFrame.getLineBox().getTopPadding() == 0) || (keepBottom &= element.getY() + element.getHeight() + parentFrame.getLineBox().getTopPadding() == parentFrame.getHeight())) {
                resultBox = this.copyFrameBox(parentCell, parentFrame, baseBox, keepLeft, keepRight, keepTop, keepBottom);
            }
            return resultBox;
        }

        protected boolean[] getFrameCellBorders(Table table, FrameCell cell, Column firstCol, Column lastCol, Row firstRow, Row lastRow) {
            Column prevCol = table.columns.getEntries().lower(firstCol);
            boolean leftBorder = !Tabulator.this.isParent(cell, firstRow.getCell(prevCol));
            Column nextCol = table.columns.getEntries().higher(lastCol);
            boolean rightBorder = !Tabulator.this.isParent(cell, firstRow.getCell(nextCol));
            Row prevRow = table.rows.getEntries().lower(firstRow);
            boolean topBorder = !Tabulator.this.isParent(cell, prevRow.getCell(firstCol));
            Row nextRow = table.rows.getEntries().higher(lastRow);
            boolean bottomBorder = !Tabulator.this.isParent(cell, nextRow.getCell(firstCol));
            return new boolean[]{leftBorder, rightBorder, topBorder, bottomBorder};
        }

        protected JRLineBox copyFrameBox(FrameCell frameCell, JRPrintFrame frame, JRLineBox baseBox, boolean keepLeft, boolean keepRight, boolean keepTop, boolean keepBottom) {
            JRLineBox resultBox = JRBoxUtil.copyBordersNoPadding(frame.getLineBox(), keepLeft, keepRight, keepTop, keepBottom, baseBox);
            resultBox = this.copyParentBox(frameCell, frame, resultBox, keepLeft, keepRight, keepTop, keepBottom);
            return resultBox;
        }
    }

    protected class ParentDrop
    implements CellVisitor<FrameCell, Cell, RuntimeException> {
        private final Map<FrameCell, FrameCell> parentMapping = new HashMap<FrameCell, FrameCell>();

        protected ParentDrop() {
        }

        protected FrameCell droppedParent(FrameCell existingParent, FrameCell parent) {
            FrameCell droppedParent;
            if (parent == null) {
                droppedParent = existingParent;
            } else if (existingParent == null) {
                droppedParent = null;
            } else if (this.parentMapping.containsKey(existingParent)) {
                droppedParent = this.parentMapping.get(existingParent);
            } else {
                droppedParent = Tabulator.this.droppedParent(existingParent, parent);
                this.parentMapping.put(existingParent, droppedParent);
            }
            return droppedParent;
        }

        @Override
        public Cell visit(ElementCell cell, FrameCell parent) {
            FrameCell droppedParent = this.droppedParent(cell.getParent(), parent);
            cell.setParent(droppedParent);
            return cell;
        }

        @Override
        public Cell visit(SplitCell cell, FrameCell parent) {
            return null;
        }

        @Override
        public Cell visit(FrameCell frameCell, FrameCell parent) {
            FrameCell droppedParent = this.droppedParent(frameCell, parent);
            return droppedParent;
        }

        @Override
        public Cell visit(LayeredCell layeredCell, FrameCell parent) {
            FrameCell droppedParent = this.droppedParent(layeredCell.getParent(), parent);
            layeredCell.setParent(droppedParent);
            return layeredCell;
        }
    }

    protected class CollapseCheck
    implements CellVisitor<Cell, Boolean, RuntimeException> {
        protected CollapseCheck() {
        }

        @Override
        public Boolean visit(ElementCell spanned, Cell cell) {
            return Tabulator.this.isSplitCell(spanned, cell);
        }

        @Override
        public Boolean visit(SplitCell spanned, Cell cell) {
            return spanned.equals(cell);
        }

        @Override
        public Boolean visit(FrameCell spanned, Cell cell) {
            return spanned.equals(cell);
        }

        @Override
        public Boolean visit(LayeredCell spanned, Cell cell) {
            return Tabulator.this.isSplitCell(spanned, cell);
        }
    }

    protected class SpanCheck
    implements CellVisitor<Cell, Boolean, RuntimeException> {
        protected SpanCheck() {
        }

        @Override
        public Boolean visit(ElementCell spanned, Cell cell) {
            return Tabulator.this.isSplitCell(spanned, cell);
        }

        @Override
        public Boolean visit(SplitCell spanned, Cell cell) {
            return false;
        }

        @Override
        public Boolean visit(FrameCell spanned, Cell cell) {
            return false;
        }

        @Override
        public Boolean visit(LayeredCell spanned, Cell cell) {
            return Tabulator.this.isSplitCell(spanned, cell);
        }
    }

    protected class SpanRangeCheck
    implements CellVisitor<Cell, Boolean, RuntimeException> {
        protected SpanRangeCheck() {
        }

        @Override
        public Boolean visit(ElementCell spanned, Cell cell) {
            return spanned.equals(cell) || Tabulator.this.isSplitCell(spanned, cell);
        }

        @Override
        public Boolean visit(SplitCell spanned, Cell cell) {
            return spanned.getSourceCell().accept(this, cell);
        }

        @Override
        public Boolean visit(FrameCell spanned, Cell cell) {
            return Tabulator.this.isParent(spanned, cell);
        }

        @Override
        public Boolean visit(LayeredCell spanned, Cell cell) {
            return spanned.equals(cell) || Tabulator.this.isSplitCell(spanned, cell);
        }
    }

    protected class ParentCheck
    implements CellVisitor<FrameCell, Boolean, RuntimeException> {
        protected ParentCheck() {
        }

        @Override
        public Boolean visit(ElementCell cell, FrameCell parentCell) {
            return Tabulator.this.isParent(parentCell, cell.getParent());
        }

        @Override
        public Boolean visit(SplitCell cell, FrameCell parentCell) {
            return Tabulator.this.isParent(parentCell, cell.getSourceCell().getParent());
        }

        @Override
        public Boolean visit(FrameCell frameCell, FrameCell parentCell) {
            return Tabulator.this.isParent(parentCell, frameCell);
        }

        @Override
        public Boolean visit(LayeredCell layeredCell, FrameCell parentCell) {
            return Tabulator.this.isParent(parentCell, layeredCell.getParent());
        }
    }
}

