/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRCsvExporterNature;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.CsvExporterConfiguration;
import net.sf.jasperreports.export.CsvReportConfiguration;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.WriterExporterOutput;

public abstract class JRAbstractCsvExporter<RC extends CsvReportConfiguration, C extends CsvExporterConfiguration, E extends JRExporterContext>
extends JRAbstractExporter<RC, C, WriterExporterOutput, E> {
    public static final String BOM_CHARACTER = "\ufeff";
    public static final String DEFAULT_ENCLOSURE = "\"";
    public static final String ESCAPE_FORMULA_CHARACTERS = "=+-@";
    protected static final String CSV_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.csv.";
    public static final String CSV_EXPORTER_KEY = "net.sf.jasperreports.csv";
    protected String fieldDelimiter;
    protected String recordDelimiter;
    protected boolean forceFieldEnclosure;
    protected String quotes;
    protected boolean escapeFormula;
    protected Writer writer;
    protected ExporterNature nature;
    protected int pageIndex;

    public JRAbstractCsvExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRAbstractCsvExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        this.writer = ((WriterExporterOutput)this.getExporterOutput()).getWriter();
        try {
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("export.common.output.writer.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            ((WriterExporterOutput)this.getExporterOutput()).close();
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        WriterExporterOutput output;
        Charset charset;
        CharsetEncoder charsetEncoder;
        CsvExporterConfiguration configuration = (CsvExporterConfiguration)this.getCurrentConfiguration();
        if (configuration.isWriteBOM().booleanValue() && (charsetEncoder = (charset = Charset.forName((output = (WriterExporterOutput)this.getExporterOutput()).getEncoding())).newEncoder()).canEncode(BOM_CHARACTER)) {
            this.writer.write(BOM_CHARACTER);
        }
        List<ExporterInputItem> items = this.exporterInput.getItems();
        for (int reportIndex = 0; reportIndex < items.size(); ++reportIndex) {
            ExporterInputItem item = items.get(reportIndex);
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages == null || pages.size() <= 0) continue;
            JRAbstractExporter.PageRange pageRange = this.getPageRange();
            int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
            int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
            this.pageIndex = startPageIndex;
            while (this.pageIndex <= endPageIndex) {
                if (Thread.interrupted()) {
                    throw new ExportInterruptedException();
                }
                JRPrintPage page = pages.get(this.pageIndex);
                this.exportPage(page);
                ++this.pageIndex;
            }
        }
        this.writer.flush();
    }

    protected abstract void exportPage(JRPrintPage var1) throws IOException;

    @Override
    public JRStyledText getStyledText(JRPrintText textElement) {
        return textElement.getFullStyledText(this.noneSelector);
    }

    protected String prepareText(String source) {
        String str = null;
        if (source != null) {
            boolean putQuotes = this.forceFieldEnclosure || source.indexOf(this.fieldDelimiter) >= 0 || source.indexOf(this.recordDelimiter) >= 0;
            StringBuilder sb = new StringBuilder();
            StringTokenizer tkzer = new StringTokenizer(source, this.quotes + "\n", true);
            String token = null;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if (this.quotes.equals(token)) {
                    putQuotes = true;
                    sb.append(this.quotes + this.quotes);
                    continue;
                }
                if ("\n".equals(token)) {
                    putQuotes = true;
                    sb.append("\n");
                    continue;
                }
                sb.append(token);
            }
            str = sb.toString();
            if (this.escapeFormula && ESCAPE_FORMULA_CHARACTERS.indexOf(str.charAt(0)) >= 0) {
                str = " " + str;
            }
            if (putQuotes) {
                str = this.quotes + str + this.quotes;
            }
        }
        return str;
    }

    @Override
    protected void initExport() {
        super.initExport();
        CsvExporterConfiguration configuration = (CsvExporterConfiguration)this.getCurrentConfiguration();
        this.fieldDelimiter = configuration.getFieldDelimiter();
        this.recordDelimiter = configuration.getRecordDelimiter();
        this.forceFieldEnclosure = configuration.getForceFieldEnclosure();
        this.quotes = configuration.getFieldEnclosure().trim().length() == 0 ? DEFAULT_ENCLOSURE : configuration.getFieldEnclosure().trim().substring(0, 1);
        this.escapeFormula = configuration.getEscapeFormula();
    }

    @Override
    protected void initReport() {
        super.initReport();
        this.nature = new JRCsvExporterNature(this.jasperReportsContext, this.filter);
    }

    @Override
    public String getExporterKey() {
        return CSV_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return CSV_EXPORTER_PROPERTIES_PREFIX;
    }
}

