/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.json;

import java.awt.GraphicsEnvironment;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.UUID;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElementUtils;
import net.sf.jasperreports.components.headertoolbar.actions.ConditionalFormattingData;
import net.sf.jasperreports.components.headertoolbar.actions.EditTextElementData;
import net.sf.jasperreports.components.headertoolbar.actions.FilterAction;
import net.sf.jasperreports.components.headertoolbar.actions.SortAction;
import net.sf.jasperreports.components.headertoolbar.json.ColumnFormatting;
import net.sf.jasperreports.components.sort.FieldFilter;
import net.sf.jasperreports.components.sort.FilterTypeBooleanOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeNumericOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeTextOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.sort.actions.FilterData;
import net.sf.jasperreports.components.sort.actions.SortData;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRIdentifiable;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.GenericElementJsonHandler;
import net.sf.jasperreports.engine.export.JsonExporterContext;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.web.commands.CommandTarget;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeaderToolbarElementJsonHandler
implements GenericElementJsonHandler {
    private static final Log log = LogFactory.getLog(HeaderToolbarElementJsonHandler.class);
    private static final String HEADER_TOOLBAR_ELEMENT_JSON_TEMPLATE = "net/sf/jasperreports/components/headertoolbar/json/resources/HeaderToolbarElementJsonTemplate.vm";
    private static final String PARAM_GENERATED_TEMPLATE_PREFIX = "net.sf.jasperreports.headertoolbar.";
    private static final List<String> datePatterns = new ArrayList<String>();
    private static final List<String> timePatterns = new ArrayList<String>();
    private static final Map<String, String> numberPatternsMap = new LinkedHashMap<String, String>();
    private static final String DURATION_PATTERN = "[h]:mm:ss";
    private static final String TABLE_UUID = "exporter_first_attempt";

    @Override
    public String getJsonFragment(JsonExporterContext context, JRGenericPrintElement element) {
        boolean templateAlreadyLoaded = false;
        String htmlFragment = null;
        String tableUUID = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.tableUUID");
        ReportContext reportContext = context.getExporterRef().getReportContext();
        if (reportContext != null && tableUUID != null) {
            ConditionalFormattingData detailCfd;
            List<BaseColumn> tableColumns;
            Column column;
            JRDesignTextField detailTextField;
            String columnUuid = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.columnUUID");
            String columnLabel = (String)element.getParameterValue("sortColumnLabel");
            if (columnLabel == null) {
                columnLabel = "";
            }
            int columnIndex = Integer.parseInt(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.columnIndex"));
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            contextMap.put("JRStringUtil", JRStringUtil.class);
            contextMap.put("tableUUID", tableUUID);
            JasperReportsContext jrContext = context.getJasperReportsContext();
            JasperPrint jasperPrint = context.getExportedReport();
            Locale locale = jasperPrint.getLocaleCode() == null ? Locale.getDefault() : JRDataUtils.getLocale(jasperPrint.getLocaleCode());
            TimeZone timeZone = this.getFilterTimeZone(jasperPrint, element);
            if (log.isDebugEnabled()) {
                log.debug((Object)("column " + columnUuid + " has locale " + locale + ", timezone " + timeZone));
            }
            Boolean isClearCache = (Boolean)reportContext.getParameterValue("net.sf.jasperreports.engine.export.clear.json.cache");
            if (!(reportContext.getParameterValue(PARAM_GENERATED_TEMPLATE_PREFIX) == null || isClearCache != null && isClearCache.booleanValue())) {
                templateAlreadyLoaded = true;
            } else {
                reportContext.setParameterValue(PARAM_GENERATED_TEMPLATE_PREFIX, true);
            }
            ColumnFormatting.store(reportContext, tableUUID, columnIndex, locale, timeZone);
            String numericFilterPattern = HeaderToolbarElementUtils.getNumberPattern(jrContext, locale);
            String dateFilterPattern = HeaderToolbarElementUtils.getDatePattern(jrContext, locale);
            String timeFilterPattern = HeaderToolbarElementUtils.getTimePattern(jrContext, locale);
            FilterAction action = new FilterAction();
            action.init(jrContext, reportContext);
            CommandTarget target = action.getCommandTarget(UUID.fromString(tableUUID));
            JasperDesign jasperDesign = null;
            JRDesignDataset dataset = null;
            StandardTable table = null;
            if (target != null) {
                JRIdentifiable identifiable = target.getIdentifiable();
                JRDesignComponentElement componentElement = identifiable instanceof JRDesignComponentElement ? (JRDesignComponentElement)identifiable : null;
                table = componentElement == null ? null : (StandardTable)componentElement.getComponent();
                JasperDesignCache cache = JasperDesignCache.getInstance(jrContext, reportContext);
                jasperDesign = cache.getJasperDesign(target.getUri());
                JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)table.getDatasetRun();
                String datasetName = datasetRun.getDatasetName();
                dataset = (JRDesignDataset)jasperDesign.getDatasetMap().get(datasetName);
            }
            if (!tableUUID.equals(context.getValue(TABLE_UUID))) {
                Map<String, ColumnInfo> columnNames = this.getAllColumnNames(element, jrContext, contextMap);
                List<Map<String, Object>> columnGroupsData = this.getColumnGroupsData(jrContext, reportContext, target, jasperDesign, dataset, table, tableUUID, locale, timeZone);
                if (!columnNames.isEmpty()) {
                    context.setValue(TABLE_UUID, tableUUID);
                    contextMap.put("allColumnNames", JacksonUtil.getInstance(jrContext).getJsonString(columnNames));
                    contextMap.put("allColumnGroupsData", JacksonUtil.getInstance(jrContext).getJsonString(columnGroupsData));
                    contextMap.put("tableName", element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.table.name"));
                    contextMap.put("hasFloatingHeader", Boolean.parseBoolean(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.table.floating.header")));
                    contextMap.put("numericPatterns", JacksonUtil.getInstance(jrContext).getJsonString(this.getNumberPatterns(numberPatternsMap)));
                    contextMap.put("datePatterns", JacksonUtil.getInstance(jrContext).getJsonString(this.getDatePatterns(datePatterns, locale)));
                    contextMap.put("timePatterns", JacksonUtil.getInstance(jrContext).getJsonString(this.getDatePatterns(timePatterns, locale)));
                    contextMap.put("numericOperators", JacksonUtil.getInstance(jrContext).getJsonString(this.getOperators(FilterTypeNumericOperatorsEnum.values())));
                    contextMap.put("dateTimeOperators", JacksonUtil.getInstance(jrContext).getJsonString(this.getOperators(FilterTypeDateOperatorsEnum.values())));
                    contextMap.put("textOperators", JacksonUtil.getInstance(jrContext).getJsonString(this.getOperators(FilterTypeTextOperatorsEnum.values())));
                    contextMap.put("booleanOperators", JacksonUtil.getInstance(jrContext).getJsonString(this.getOperators(FilterTypeBooleanOperatorsEnum.values())));
                    contextMap.put("numericFilterPattern", numericFilterPattern);
                    contextMap.put("dateFilterPattern", dateFilterPattern);
                    contextMap.put("timeFilterPattern", timeFilterPattern);
                    contextMap.put("calendarDatePattern", HeaderToolbarElementUtils.getCalendarDatePattern(jrContext, locale));
                    contextMap.put("calendarTimePattern", HeaderToolbarElementUtils.getCalendarTimePattern(jrContext, locale));
                    contextMap.put("exporterFirstAttempt", true);
                }
            }
            contextMap.put("templateAlreadyLoaded", templateAlreadyLoaded);
            Boolean canSort = Boolean.parseBoolean(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.can.sort"));
            Boolean canFilter = Boolean.parseBoolean(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.can.filter"));
            if (element.getModeValue() == ModeEnum.OPAQUE) {
                contextMap.put("backgroundColor", JRColorUtil.getColorHexa(element.getBackcolor()));
            }
            contextMap.put("columnUuid", columnUuid);
            contextMap.put("columnLabel", JRStringUtil.htmlEncode(columnLabel));
            contextMap.put("columnIndex", columnIndex);
            contextMap.put("dataType", FilterTypesEnum.TEXT.getName());
            contextMap.put("canSort", canSort);
            contextMap.put("canFilter", canFilter);
            contextMap.put("fontExtensionsFontNames", this.getFontExtensionsFontNames(jrContext));
            contextMap.put("systemFontNames", this.getSystemFontNames(jrContext));
            this.setColumnHeaderData(columnLabel, columnIndex, target, contextMap, jrContext, reportContext, locale);
            EditTextElementData columnValueData = this.setColumnValueData(columnIndex, target, contextMap, jrContext, reportContext, locale);
            String columnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.sortColumnName");
            String columnComponentName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.column.name");
            String columnType = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.sortColumnType");
            FilterTypesEnum filterType = FilterTypesEnum.getByName(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.filter.type"));
            if (columnComponentName == null) {
                columnComponentName = columnName;
            }
            contextMap.put("columnName", columnComponentName);
            if (canFilter.booleanValue()) {
                FilterData filterData = HeaderToolbarElementJsonHandler.getFilterData(jrContext, dataset, columnName, columnType, filterType, columnValueData.getFormatPattern(), locale, timeZone);
                contextMap.put("dataType", filterType.getName());
                contextMap.put("filterData", JacksonUtil.getInstance(jrContext).getJsonString(filterData));
                contextMap.put("filterTableUuid", filterData.getTableUuid());
            }
            if (canSort.booleanValue()) {
                SortData sortAscData = new SortData(tableUUID, columnName, columnType, "Asc");
                SortData sortDescData = new SortData(tableUUID, columnName, columnType, "Dsc");
                String sortField = this.getCurrentSortField(jrContext, reportContext, tableUUID, columnName, columnType);
                if (sortField != null) {
                    String[] sortActionData = HeaderToolbarElementUtils.extractColumnInfo(sortField);
                    boolean isAscending = "Asc".equals(sortActionData[2]);
                    if (isAscending) {
                        sortAscData.setSortOrder("None");
                    } else {
                        sortDescData.setSortOrder("None");
                    }
                }
                contextMap.put("sortAscData", JacksonUtil.getInstance(jrContext).getJsonString(sortAscData));
                contextMap.put("sortDescData", JacksonUtil.getInstance(jrContext).getJsonString(sortDescData));
            }
            if ((detailTextField = TableUtil.getCellElement(JRDesignTextField.class, (column = (Column)(tableColumns = TableUtil.getAllColumns(table)).get(columnIndex)).getDetailCell(), true)) != null && (detailCfd = HeaderToolbarElementJsonHandler.getConditionalFormattingData(element, jrContext, dataset, detailTextField, null, locale, timeZone)) != null) {
                contextMap.put("conditionalFormattingData", JacksonUtil.getInstance(jrContext).getJsonString(detailCfd));
            }
            htmlFragment = VelocityUtil.processTemplate(HEADER_TOOLBAR_ELEMENT_JSON_TEMPLATE, contextMap);
        }
        return htmlFragment;
    }

    protected TimeZone getFilterTimeZone(JasperPrint jasperPrint, JRGenericPrintElement element) {
        String formatTimeZone = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.format.time.zone");
        TimeZone timeZone = formatTimeZone != null ? JRDataUtils.getTimeZone(formatTimeZone) : (jasperPrint.getTimeZoneId() != null ? JRDataUtils.getTimeZone(jasperPrint.getTimeZoneId()) : TimeZone.getDefault());
        return timeZone;
    }

    private List<HashMap<String, String>> getDatePatterns(List<String> datePatterns, Locale locale) {
        ArrayList<HashMap<String, String>> formatPatterns = new ArrayList<HashMap<String, String>>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", locale);
        Date today = new Date();
        for (String datePattern : datePatterns) {
            HashMap<String, String> keys = new HashMap<String, String>();
            sdf.applyPattern(datePattern);
            keys.put("key", datePattern);
            keys.put("val", sdf.format(today));
            formatPatterns.add(keys);
        }
        return formatPatterns;
    }

    private List<HashMap<String, String>> getNumberPatterns(Map<String, String> numberPatternsMap) {
        ArrayList<HashMap<String, String>> formatPatterns = new ArrayList<HashMap<String, String>>();
        for (Map.Entry<String, String> entry : numberPatternsMap.entrySet()) {
            HashMap<String, String> keys = new HashMap<String, String>();
            keys.put("key", entry.getKey());
            keys.put("val", entry.getValue());
            formatPatterns.add(keys);
        }
        return formatPatterns;
    }

    private String getCurrentSortField(JasperReportsContext jasperReportsContext, ReportContext reportContext, String uuid, String sortColumnName, String sortColumnType) {
        JasperDesignCache cache = JasperDesignCache.getInstance(jasperReportsContext, reportContext);
        SortAction action = new SortAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(uuid));
        if (target != null) {
            JRIdentifiable identifiable = target.getIdentifiable();
            JRDesignComponentElement componentElement = identifiable instanceof JRDesignComponentElement ? (JRDesignComponentElement)identifiable : null;
            StandardTable table = componentElement == null ? null : (StandardTable)componentElement.getComponent();
            JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)table.getDatasetRun();
            String datasetName = datasetRun.getDatasetName();
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getDatasetMap().get(datasetName);
            List<JRSortField> existingFields = dataset.getSortFieldsList();
            String sortField = null;
            if (existingFields != null && existingFields.size() > 0) {
                for (JRSortField field : existingFields) {
                    if (!field.getName().equals(sortColumnName) || !field.getType().getName().equals(sortColumnType)) continue;
                    sortField = sortColumnName + ":" + sortColumnType + ":";
                    switch (field.getOrderValue()) {
                        case ASCENDING: {
                            sortField = sortField + "Asc";
                            break;
                        }
                        case DESCENDING: {
                            sortField = sortField + "Dsc";
                        }
                    }
                    break;
                }
            }
            return sortField;
        }
        return null;
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    private List<String> getOperators(NamedEnum[] operators) {
        ArrayList<String> result = new ArrayList<String>();
        for (NamedEnum operator : operators) {
            result.add(((Enum)((Object)operator)).name());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static FilterData getFilterData(JasperReportsContext jasperReportsContext, JRDesignDataset dataset, String columnName, String columnType, FilterTypesEnum filterType, String columnValuePattern, Locale locale, TimeZone timeZone) {
        String serializedFilters = "[]";
        JRPropertiesMap propertiesMap = dataset.getPropertiesMap();
        if (propertiesMap.getProperty("net.sf.jasperreports.filters") != null) {
            serializedFilters = propertiesMap.getProperty("net.sf.jasperreports.filters");
        }
        ArrayList<DatasetFilter> filters = new ArrayList<DatasetFilter>();
        List<FieldFilter> existingFilters = JacksonUtil.getInstance(jasperReportsContext).loadList(serializedFilters, FieldFilter.class);
        if (existingFilters.size() > 0) {
            for (DatasetFilter datasetFilter : existingFilters) {
                if (!((FieldFilter)datasetFilter).getField().equals(columnName)) continue;
                filters.add(datasetFilter);
                break;
            }
        }
        FilterData filterData = new FilterData();
        filterData.setFieldName(columnName);
        filterData.setFilterType(filterType.getName());
        filterData.setIsField(SortFieldTypeEnum.FIELD.equals(SortFieldTypeEnum.getByName(columnType)));
        if (filters.size() > 0) {
            FieldFilter fieldFilter = (FieldFilter)filters.get(0);
            filterData.setFieldValueStart(fieldFilter.getFilterValueStart());
            filterData.setFieldValueEnd(fieldFilter.getFilterValueEnd());
            filterData.setFilterTypeOperator(fieldFilter.getFilterTypeOperator());
            filterData.setFilterType(fieldFilter.getFilterType());
            filterData.setFilterPattern(fieldFilter.getFilterPattern());
            filterData.setLocaleCode(fieldFilter.getLocaleCode());
            filterData.setTimeZoneId(fieldFilter.getTimeZoneId());
        }
        if (filterType.getName().equals(filterData.getFilterType())) {
            void var13_18;
            String string = HeaderToolbarElementUtils.getFilterPattern(jasperReportsContext, locale, filterType);
            if (FilterTypesEnum.NUMERIC.equals(filterType) && DURATION_PATTERN.equals(columnValuePattern)) {
                String string2 = DURATION_PATTERN;
            }
            HeaderToolbarElementUtils.updateFilterData(filterData, (String)var13_18, locale, timeZone);
        }
        return filterData;
    }

    private void setColumnHeaderData(String sortColumnLabel, Integer columnIndex, CommandTarget target, Map<String, Object> contextMap, JasperReportsContext jasperReportsContext, ReportContext reportContext, Locale locale) {
        if (target != null) {
            StandardColumn column;
            JRDesignTextElement textElement;
            JRIdentifiable identifiable = target.getIdentifiable();
            JRDesignComponentElement componentElement = identifiable instanceof JRDesignComponentElement ? (JRDesignComponentElement)identifiable : null;
            StandardTable table = componentElement == null ? null : (StandardTable)componentElement.getComponent();
            List<BaseColumn> tableColumns = TableUtil.getAllColumns(table);
            if (columnIndex != null && (textElement = TableUtil.getCellElement(JRDesignTextElement.class, (column = (StandardColumn)tableColumns.get(columnIndex)).getColumnHeader(), true)) != null) {
                EditTextElementData textElementData = new EditTextElementData();
                textElementData.setHeadingName(JRStringUtil.htmlEncode(sortColumnLabel));
                textElementData.setColumnIndex(columnIndex);
                JRDesignTextElement styledElement = this.resolveElementStyle(textElement, reportContext, target);
                HeaderToolbarElementUtils.copyTextElementStyle(textElementData, styledElement, locale);
                contextMap.put("colHeaderData", JacksonUtil.getInstance(jasperReportsContext).getJsonString(textElementData));
            }
        }
    }

    private JRDesignTextElement resolveElementStyle(JRDesignTextElement element, ReportContext context, CommandTarget target) {
        JRStyle elementStyle;
        List<JRStyle> reportStyles;
        boolean hasExternalStyle;
        JRStyle defaultStyle = element.getDefaultStyleProvider() == null ? null : element.getDefaultStyleProvider().getDefaultStyle();
        boolean bl = hasExternalStyle = this.hasExternalStyle(element) || defaultStyle != null && this.hasExternalStyle(defaultStyle);
        if (!hasExternalStyle && defaultStyle != null) {
            return element;
        }
        JasperDesignCache designCache = JasperDesignCache.getExistingInstance(context);
        List<JRStyle> list = designCache == null ? null : (reportStyles = designCache.getStyles(target.getUri(), target.getIdentifiable() == null ? null : target.getIdentifiable().getUUID()));
        if (reportStyles == null || reportStyles.isEmpty()) {
            return element;
        }
        JRStyle externalDefault = null;
        if (defaultStyle == null) {
            for (JRStyle style : reportStyles) {
                if (!style.isDefault()) continue;
                externalDefault = style;
            }
            if (!hasExternalStyle && externalDefault == null) {
                return element;
            }
        }
        if (element.getStyle() == null && element.getStyleNameReference() == null) {
            elementStyle = externalDefault;
        } else {
            String elementStyleName = element.getStyleNameReference() == null ? element.getStyle().getName() : element.getStyleNameReference();
            elementStyle = null;
            for (JRStyle style : reportStyles) {
                if (!style.getName().equals(elementStyleName)) continue;
                elementStyle = style;
            }
        }
        if (elementStyle == null) {
            return element;
        }
        JRDesignTextElement elementClone = (JRDesignTextElement)element.clone();
        elementClone.setStyle(elementStyle);
        return elementClone;
    }

    private boolean hasExternalStyle(JRStyleContainer styleContainer) {
        if (styleContainer.getStyle() == null && styleContainer.getStyleNameReference() != null) {
            return true;
        }
        for (JRStyle style = styleContainer.getStyle(); style != null; style = style.getStyle()) {
            if (style.getStyle() != null || style.getStyleNameReference() == null) continue;
            return true;
        }
        return false;
    }

    private EditTextElementData setColumnValueData(Integer columnIndex, CommandTarget target, Map<String, Object> contextMap, JasperReportsContext jasperReportsContext, ReportContext reportContext, Locale locale) {
        EditTextElementData textElementData = new EditTextElementData();
        if (target != null) {
            StandardColumn column;
            JRDesignTextField textElement;
            JRIdentifiable identifiable = target.getIdentifiable();
            JRDesignComponentElement componentElement = identifiable instanceof JRDesignComponentElement ? (JRDesignComponentElement)identifiable : null;
            StandardTable table = componentElement == null ? null : (StandardTable)componentElement.getComponent();
            List<BaseColumn> tableColumns = TableUtil.getAllColumns(table);
            if (columnIndex != null && (textElement = TableUtil.getCellElement(JRDesignTextField.class, (column = (StandardColumn)tableColumns.get(columnIndex)).getDetailCell(), true)) != null) {
                textElementData.setColumnIndex(columnIndex);
                JRDesignTextElement styledElement = this.resolveElementStyle(textElement, reportContext, target);
                HeaderToolbarElementUtils.copyTextElementStyle(textElementData, styledElement, locale);
            }
        }
        contextMap.put("colValueData", JacksonUtil.getInstance(jasperReportsContext).getJsonString(textElementData));
        return textElementData;
    }

    private Map<String, ColumnInfo> getAllColumnNames(JRGenericPrintElement element, JasperReportsContext jasperReportsContext, Map<String, Object> contextMap) {
        int prefixLength = "column.".length();
        HashMap<String, ColumnInfo> columnNames = new HashMap<String, ColumnInfo>();
        for (String paramName : element.getParameterNames()) {
            if (!paramName.startsWith("column.")) continue;
            String columnName = (String)element.getParameterValue(paramName);
            String[] tokens = paramName.substring(prefixLength).split("\\|");
            if (columnName == null || columnName.trim().length() == 0) {
                columnName = "Column_" + tokens[0];
            }
            columnNames.put(tokens[0], new ColumnInfo(tokens[0], JRStringUtil.htmlEncode(columnName), tokens[1], false, Boolean.valueOf(tokens[2])));
        }
        return columnNames;
    }

    private boolean setTextElements(List<GroupCell> groupCells, Map<JRDesignTextElement, GroupInfo> groups, String groupType, Integer columnIndex) {
        boolean result = false;
        if (groupCells != null) {
            for (GroupCell gc : groupCells) {
                JRDesignTextElement textElement = TableUtil.getCellElement(JRDesignTextElement.class, gc.getCell(), false);
                if (textElement == null) continue;
                result = true;
                if (groups.containsKey(textElement)) {
                    groups.get(textElement).addForColumn(columnIndex);
                    continue;
                }
                GroupInfo gi = new GroupInfo(gc.getGroupName() != null ? gc.getGroupName() : groupType + "_" + columnIndex, groupType);
                gi.addForColumn(columnIndex);
                groups.put(textElement, gi);
            }
        }
        return result;
    }

    private List<Map<String, Object>> getColumnGroupsData(JasperReportsContext jasperReportsContext, ReportContext reportContext, CommandTarget target, JasperDesign jasperDesign, JRDesignDataset dataset, StandardTable table, String tableUuid, Locale locale, TimeZone timeZone) {
        Object textElement;
        List<BaseColumn> allColumns = TableUtil.getAllColumns(table);
        int i = 0;
        HashMap<JRDesignTextElement, GroupInfo> groups = new HashMap<JRDesignTextElement, GroupInfo>();
        for (BaseColumn bc : allColumns) {
            List<ColumnGroup> colGroups = TableUtil.getHierarchicalColumnGroupsForColumn(bc, table.getColumns(), table);
            boolean found = this.setTextElements(bc.getGroupHeaders(), groups, "groupheading", i);
            if (!found) {
                for (ColumnGroup cg : colGroups) {
                    if (cg.getGroupHeaders() != null && (found = this.setTextElements(cg.getGroupHeaders(), groups, "groupheading", i))) break;
                }
            }
            if (!(found = this.setTextElements(bc.getGroupFooters(), groups, "groupsubtotal", i))) {
                for (ColumnGroup cg : colGroups) {
                    if (cg.getGroupFooters() != null && (found = this.setTextElements(cg.getGroupFooters(), groups, "groupsubtotal", i))) break;
                }
            }
            found = false;
            if (bc.getTableFooter() != null && (textElement = TableUtil.getCellElement(JRDesignTextElement.class, bc.getTableFooter(), false)) != null) {
                found = true;
                if (groups.containsKey(textElement)) {
                    ((GroupInfo)groups.get(textElement)).addForColumn(i);
                } else {
                    GroupInfo gi = new GroupInfo("Tabletotal_" + i, "tabletotal");
                    gi.addForColumn(i);
                    groups.put((JRDesignTextElement)textElement, gi);
                }
            }
            if (!found) {
                textElement = colGroups.iterator();
                while (textElement.hasNext()) {
                    ColumnGroup cg;
                    cg = (ColumnGroup)textElement.next();
                    if (cg.getTableFooter() == null) continue;
                    JRDesignTextElement textElement2 = TableUtil.getCellElement(JRDesignTextElement.class, cg.getTableFooter(), false);
                    if (textElement2 != null) {
                        found = true;
                        if (groups.containsKey(textElement2)) {
                            ((GroupInfo)groups.get(textElement2)).addForColumn(i);
                        } else {
                            GroupInfo gi = new GroupInfo("Tabletotal_" + i, "tabletotal");
                            gi.addForColumn(i);
                            groups.put(textElement2, gi);
                        }
                    }
                    if (!found) continue;
                    break;
                }
            }
            ++i;
        }
        ArrayList<Map<String, Object>> groupsData = new ArrayList<Map<String, Object>>();
        i = 0;
        for (Map.Entry entry : groups.entrySet()) {
            ConditionalFormattingData cfData;
            textElement = (JRDesignTextElement)entry.getKey();
            GroupInfo groupInfo = (GroupInfo)entry.getValue();
            EditTextElementData textElementData = new EditTextElementData();
            textElementData.setGroupName(groupInfo.getName());
            JRDesignTextElement styledElement = this.resolveElementStyle((JRDesignTextElement)textElement, reportContext, target);
            HeaderToolbarElementUtils.copyTextElementStyle(textElementData, styledElement, locale);
            HashMap<String, Object> groupData = new HashMap<String, Object>();
            groupData.put("groupType", groupInfo.getType());
            groupData.put("id", groupInfo.getType() + "_" + i);
            groupData.put("groupData", textElementData);
            groupData.put("groupName", groupInfo.getName());
            groupData.put("forColumns", groupInfo.getForColumns());
            JRDesignTextField textField = textElement instanceof JRDesignTextField ? (JRDesignTextField)textElement : null;
            ConditionalFormattingData conditionalFormattingData = cfData = textField == null ? null : HeaderToolbarElementJsonHandler.getConditionalFormattingData(null, jasperReportsContext, dataset, textField, groupInfo.getName(), locale, timeZone);
            if (cfData != null) {
                groupData.put("dataType", cfData.getConditionType());
                groupData.put("conditionalFormattingData", cfData);
            } else {
                groupData.put("dataType", FilterTypesEnum.TEXT.getName());
            }
            groupsData.add(groupData);
            ++i;
        }
        return groupsData;
    }

    private static ConditionalFormattingData getConditionalFormattingData(JRGenericPrintElement element, JasperReportsContext jasperReportsContext, JRDesignDataset dataset, JRDesignTextField textField, String groupName, Locale locale, TimeZone timeZone) {
        String conditionTypeProp;
        FilterTypesEnum conditionType = null;
        if (element != null) {
            conditionTypeProp = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.filter.type");
            if (element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.headertoolbar.column.field")) {
                textField.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.column.field", element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.column.field"));
            } else if (element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.headertoolbar.column.variable")) {
                textField.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.column.variable", element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.column.variable"));
            }
        } else {
            conditionTypeProp = textField.getPropertiesMap().getProperty("net.sf.jasperreports.components.condition.type");
        }
        if (conditionTypeProp == null) {
            JRExpressionChunk[] chunks;
            JRExpression expression = textField.getExpression();
            if (expression != null && (chunks = expression.getChunks()) != null && chunks.length == 1) {
                JRExpressionChunk expressionChunk = expression.getChunks()[0];
                String fieldOrVariableName = expressionChunk.getText();
                switch (expressionChunk.getType()) {
                    case 3: {
                        JRField field = HeaderToolbarElementUtils.getField(fieldOrVariableName, dataset);
                        conditionType = HeaderToolbarElementUtils.getFilterType(field.getValueClass());
                        break;
                    }
                    case 4: {
                        JRVariable variable = HeaderToolbarElementUtils.getVariable(fieldOrVariableName, dataset);
                        conditionType = HeaderToolbarElementUtils.getFilterType(variable.getValueClass());
                        break;
                    }
                }
            }
        } else {
            conditionType = FilterTypesEnum.getByName(conditionTypeProp);
        }
        ConditionalFormattingData cfd = null;
        if (conditionType != null) {
            cfd = HeaderToolbarElementUtils.getConditionalFormattingData(textField, jasperReportsContext);
            if (cfd == null) {
                cfd = new ConditionalFormattingData();
                if (groupName != null) {
                    cfd.setGroupName(groupName);
                }
                cfd.setConditionType(conditionType.getName());
            }
            if (conditionType.getName().equals(cfd.getConditionType())) {
                String conditionPattern = HeaderToolbarElementUtils.getFilterPattern(jasperReportsContext, locale, conditionType);
                if (FilterTypesEnum.NUMERIC.equals(conditionType) && DURATION_PATTERN.equals(textField.getPattern())) {
                    conditionPattern = DURATION_PATTERN;
                }
                HeaderToolbarElementUtils.updateConditionalFormattingData(cfd, conditionPattern, locale, timeZone);
            }
        }
        return cfd;
    }

    private Set<String> getFontExtensionsFontNames(JasperReportsContext jasperReportsContext) {
        TreeSet<String> classes = new TreeSet<String>();
        Collection<String> extensionFonts = FontUtil.getInstance(jasperReportsContext).getFontNames();
        for (String fname : extensionFonts) {
            classes.add(fname);
        }
        return classes;
    }

    private Set<String> getSystemFontNames(JasperReportsContext jasperReportsContext) {
        Set<String> fontExtensionsFontNames = this.getFontExtensionsFontNames(jasperReportsContext);
        TreeSet<String> classes = new TreeSet<String>();
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (!fontExtensionsFontNames.add(name)) continue;
            classes.add(name);
        }
        return classes;
    }

    static {
        datePatterns.add("dd/MM/yyyy");
        datePatterns.add("MM/dd/yyyy");
        datePatterns.add("yyyy/MM/dd");
        datePatterns.add("EEEEE dd MMMMM yyyy");
        datePatterns.add("MMMMM dd. yyyy");
        datePatterns.add("dd/MM");
        datePatterns.add("dd/MM/yy");
        datePatterns.add("dd-MMM");
        datePatterns.add("dd-MMM-yy");
        datePatterns.add("MMM-yy");
        datePatterns.add("MMMMM-yy");
        datePatterns.add("dd/MM/yyyy h.mm a");
        datePatterns.add("dd/MM/yyyy HH.mm.ss");
        datePatterns.add("MMM");
        datePatterns.add("d/M/yyyy");
        datePatterns.add("dd-MMM-yyyy");
        datePatterns.add("yyyy.MM.dd G 'at' HH:mm:ss z");
        datePatterns.add("EEE. MMM d. ''yy");
        datePatterns.add("yyyy.MMMMM.dd GGG hh:mm aaa");
        datePatterns.add("EEE. d MMM yyyy HH:mm:ss Z");
        datePatterns.add("yyMMddHHmmssZ");
        timePatterns.add("hh:mm aaa");
        timePatterns.add("hh:mm:ss aaa");
        timePatterns.add("HH:mm");
        timePatterns.add("HH:mm:ss");
        numberPatternsMap.put("###0;-###0", "-1234");
        numberPatternsMap.put("###0;###0-", "1234-");
        numberPatternsMap.put("###0;(###0)", "(1234)");
        numberPatternsMap.put("###0;(-###0)", "(-1234)");
        numberPatternsMap.put("###0;(###0-)", "(1234-)");
        numberPatternsMap.put(DURATION_PATTERN, DURATION_PATTERN);
    }

    public static class GroupInfo {
        public static final String TYPE_GROUP_HEADING = "groupheading";
        public static final String TYPE_GROUP_SUBTOTAL = "groupsubtotal";
        public static final String TYPE_TABLE_TOTAL = "tabletotal";
        private String name;
        private String type;
        private List<Integer> forColumns;

        public GroupInfo(String name, String type) {
            this.name = name;
            this.type = type;
            this.forColumns = new ArrayList<Integer>();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public void addForColumn(Integer index) {
            this.forColumns.add(index);
        }

        public List<Integer> getForColumns() {
            return this.forColumns;
        }
    }

    public static class ColumnInfo {
        private String index;
        private String label;
        private String uuid;
        private boolean visible;
        private boolean interactive;

        private ColumnInfo(String index, String label, String uuid, boolean visible, boolean interactive) {
            this.index = index;
            this.label = label;
            this.uuid = uuid;
            this.visible = visible;
            this.interactive = interactive;
        }

        public String getIndex() {
            return this.index;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUuid() {
            return this.uuid;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public boolean getInteractive() {
            return this.interactive;
        }
    }
}

