/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.ChartThemeBundle;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartRenderableFactory;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.DefaultChartTheme;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.data.Range;

public final class ChartUtil {
    public static final String EXCEPTION_MESSAGE_KEY_CHART_THEME_NOT_FOUND = "charts.util.chart.theme.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_RENDERER_FACTORY_NOT_SPECIFIED = "charts.util.renderer.factory.not.specified";
    private static final JRSingletonCache<ChartRenderableFactory> CHART_RENDERABLE_FACTORY_CACHE = new JRSingletonCache<ChartRenderableFactory>(ChartRenderableFactory.class);
    protected static final double AUTO_TICK_UNIT_THRESHOLD = 1.0E12;
    protected static final double AUTO_TICK_UNIT_FACTOR = 1000.0;
    private JasperReportsContext jasperReportsContext;

    private ChartUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static ChartUtil getDefaultInstance() {
        return new ChartUtil(DefaultJasperReportsContext.getInstance());
    }

    public static ChartUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new ChartUtil(jasperReportsContext);
    }

    public static List<JRPrintImageAreaHyperlink> getImageAreaHyperlinks(JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Graphics2D grx, Rectangle2D renderingArea) {
        ArrayList<JRPrintImageAreaHyperlink> areaHyperlinks = null;
        if (chartHyperlinkProvider != null && chartHyperlinkProvider.hasHyperlinks()) {
            ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
            if (grx == null) {
                chart.createBufferedImage((int)renderingArea.getWidth(), (int)renderingArea.getHeight(), renderingInfo);
            } else {
                chart.draw(grx, renderingArea, renderingInfo);
            }
            EntityCollection entityCollection = renderingInfo.getEntityCollection();
            if (entityCollection != null && entityCollection.getEntityCount() > 0) {
                areaHyperlinks = new ArrayList<JRPrintImageAreaHyperlink>(entityCollection.getEntityCount());
                for (ChartEntity entity : entityCollection) {
                    JRPrintHyperlink printHyperlink = chartHyperlinkProvider.getEntityHyperlink(entity);
                    if (printHyperlink == null) continue;
                    JRPrintImageArea area = ChartUtil.getImageArea(entity);
                    JRPrintImageAreaHyperlink areaHyperlink = new JRPrintImageAreaHyperlink();
                    areaHyperlink.setArea(area);
                    areaHyperlink.setHyperlink(printHyperlink);
                    areaHyperlinks.add(areaHyperlink);
                }
            }
        }
        return areaHyperlinks;
    }

    private static JRPrintImageArea getImageArea(ChartEntity entity) {
        JRPrintImageArea area = new JRPrintImageArea();
        area.setShape(JRPrintImageArea.getShape(entity.getShapeType()));
        int[] coordinates = ChartUtil.getCoordinates(entity);
        if (coordinates != null) {
            area.setCoordinates(coordinates);
        }
        return area;
    }

    private static int[] getCoordinates(ChartEntity entity) {
        int[] coordinates = null;
        String shapeCoords = entity.getShapeCoords();
        if (shapeCoords != null && shapeCoords.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(shapeCoords, ",");
            coordinates = new int[tokens.countTokens()];
            int idx = 0;
            while (tokens.hasMoreTokens()) {
                String coord = tokens.nextToken();
                coordinates[idx] = Integer.parseInt(coord);
                ++idx;
            }
        }
        return coordinates;
    }

    public ChartTheme getTheme(String themeName) {
        if (themeName == null) {
            return new DefaultChartTheme();
        }
        List<ChartThemeBundle> themeBundles = this.jasperReportsContext.getExtensions(ChartThemeBundle.class);
        for (ChartThemeBundle bundle : themeBundles) {
            ChartTheme chartTheme = bundle.getChartTheme(themeName);
            if (chartTheme == null) continue;
            return chartTheme;
        }
        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CHART_THEME_NOT_FOUND, themeName);
    }

    public ChartRenderableFactory getChartRenderableFactory(String renderType) {
        String factoryClass = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty("net.sf.jasperreports.chart.renderer.factory." + renderType);
        if (factoryClass == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_RENDERER_FACTORY_NOT_SPECIFIED, renderType);
        }
        try {
            return CHART_RENDERABLE_FACTORY_CACHE.getCachedInstance(factoryClass);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public TickUnitSource createIntegerTickUnits(Locale locale) {
        DecimalFormatSymbols formatSymbols = DecimalFormatSymbols.getInstance(locale);
        TickUnits units = new TickUnits();
        DecimalFormat df0 = new DecimalFormat("0", formatSymbols);
        DecimalFormat df1 = new DecimalFormat("#,##0", formatSymbols);
        units.add((TickUnit)new NumberTickUnit(1.0, (NumberFormat)df0));
        units.add((TickUnit)new NumberTickUnit(2.0, (NumberFormat)df0));
        units.add((TickUnit)new NumberTickUnit(5.0, (NumberFormat)df0));
        units.add((TickUnit)new NumberTickUnit(10.0, (NumberFormat)df0));
        units.add((TickUnit)new NumberTickUnit(20.0, (NumberFormat)df0));
        units.add((TickUnit)new NumberTickUnit(50.0, (NumberFormat)df0));
        units.add((TickUnit)new NumberTickUnit(100.0, (NumberFormat)df0));
        units.add((TickUnit)new NumberTickUnit(200.0, (NumberFormat)df0));
        units.add((TickUnit)new NumberTickUnit(500.0, (NumberFormat)df0));
        units.add((TickUnit)new NumberTickUnit(1000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(10000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(20000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(50000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(100000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(200000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(500000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1000000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2000000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5000000.0, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E7, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E7, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E7, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E8, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E8, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E8, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E9, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E9, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E9, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E10, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E10, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E10, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E11, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E11, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E11, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E12, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E12, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E12, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E13, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E13, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E13, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E14, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E14, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E14, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E15, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E15, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E15, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E16, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E16, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E16, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E17, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E17, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E17, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E18, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.0E18, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E18, (NumberFormat)df1));
        return units;
    }

    public TickUnitSource createStandardTickUnits(Locale locale) {
        DecimalFormatSymbols formatSymbols = DecimalFormatSymbols.getInstance(locale);
        TickUnits units = new TickUnits();
        DecimalFormat df0 = new DecimalFormat("0.00000000", formatSymbols);
        DecimalFormat df1 = new DecimalFormat("0.0000000", formatSymbols);
        DecimalFormat df2 = new DecimalFormat("0.000000", formatSymbols);
        DecimalFormat df3 = new DecimalFormat("0.00000", formatSymbols);
        DecimalFormat df4 = new DecimalFormat("0.0000", formatSymbols);
        DecimalFormat df5 = new DecimalFormat("0.000", formatSymbols);
        DecimalFormat df6 = new DecimalFormat("0.00", formatSymbols);
        DecimalFormat df7 = new DecimalFormat("0.0", formatSymbols);
        DecimalFormat df8 = new DecimalFormat("#,##0", formatSymbols);
        DecimalFormat df9 = new DecimalFormat("#,###,##0", formatSymbols);
        DecimalFormat df10 = new DecimalFormat("#,###,###,##0", formatSymbols);
        units.add((TickUnit)new NumberTickUnit(1.0E-7, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(1.0E-6, (NumberFormat)df2));
        units.add((TickUnit)new NumberTickUnit(1.0E-5, (NumberFormat)df3));
        units.add((TickUnit)new NumberTickUnit(1.0E-4, (NumberFormat)df4));
        units.add((TickUnit)new NumberTickUnit(0.001, (NumberFormat)df5));
        units.add((TickUnit)new NumberTickUnit(0.01, (NumberFormat)df6));
        units.add((TickUnit)new NumberTickUnit(0.1, (NumberFormat)df7));
        units.add((TickUnit)new NumberTickUnit(1.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(10.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(100.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(1000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(10000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(100000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(1000000.0, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(1.0E7, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(1.0E8, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(1.0E9, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(1.0E10, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(1.0E11, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(2.5E-7, (NumberFormat)df0));
        units.add((TickUnit)new NumberTickUnit(2.5E-6, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(2.5E-5, (NumberFormat)df2));
        units.add((TickUnit)new NumberTickUnit(2.5E-4, (NumberFormat)df3));
        units.add((TickUnit)new NumberTickUnit(0.0025, (NumberFormat)df4));
        units.add((TickUnit)new NumberTickUnit(0.025, (NumberFormat)df5));
        units.add((TickUnit)new NumberTickUnit(0.25, (NumberFormat)df6));
        units.add((TickUnit)new NumberTickUnit(2.5, (NumberFormat)df7));
        units.add((TickUnit)new NumberTickUnit(25.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(250.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2500.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(25000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(250000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2500000.0, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(2.5E7, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(2.5E8, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(2.5E9, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(2.5E10, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(2.5E11, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(5.0E-7, (NumberFormat)df1));
        units.add((TickUnit)new NumberTickUnit(5.0E-6, (NumberFormat)df2));
        units.add((TickUnit)new NumberTickUnit(5.0E-5, (NumberFormat)df3));
        units.add((TickUnit)new NumberTickUnit(5.0E-4, (NumberFormat)df4));
        units.add((TickUnit)new NumberTickUnit(0.005, (NumberFormat)df5));
        units.add((TickUnit)new NumberTickUnit(0.05, (NumberFormat)df6));
        units.add((TickUnit)new NumberTickUnit(0.5, (NumberFormat)df7));
        units.add((TickUnit)new NumberTickUnit(5.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(50.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(500.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(50000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(500000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5000000.0, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(5.0E7, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(5.0E8, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(5.0E9, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(5.0E10, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(5.0E11, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(1.0E12, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2.5E12, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5.0E12, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(1.0E13, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2.5E13, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5.0E13, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(1.0E14, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2.5E14, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5.0E14, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(1.0E15, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2.5E15, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5.0E15, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(1.0E16, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2.5E16, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5.0E16, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(1.0E17, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2.5E17, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5.0E17, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(1.0E18, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2.5E18, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5.0E18, (NumberFormat)df8));
        return units;
    }

    public void setAutoTickUnit(NumberAxis numberAxis) {
        Range range;
        if (numberAxis.isAutoTickUnitSelection() && (range = numberAxis.getRange()).getLength() >= 1.0E12) {
            double autoSize = range.getLength() / 1.0E12;
            TickUnit unit = numberAxis.getStandardTickUnits().getCeilingTickUnit(autoSize);
            numberAxis.setTickUnit((NumberTickUnit)unit, false, false);
        }
    }
}

