/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.range;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Objects;
import java.util.function.Function;

public final class Range<T extends Comparable<? super T>>
implements Serializable {
    public static final int LOWER_INCLUSIVE = 2;
    public static final int LOWER_EXCLUSIVE = 4;
    public static final int UPPER_INCLUSIVE = 8;
    public static final int UPPER_EXCLUSIVE = 16;
    public static final int LOWER_INFINITE = 36;
    public static final int UPPER_INFINITE = 80;
    public static final String EMPTY = "empty";
    public static final String INFINITY = "infinity";
    private static final DateTimeFormatter LOCAL_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 1, 6, false).optionalEnd().toFormatter();
    private static final DateTimeFormatter ZONE_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 1, 6, false).optionalEnd().appendOffset("+HH:mm", "Z").toFormatter();
    private final T lower;
    private final T upper;
    private final int mask;
    private final Class<T> clazz;

    private Range(T lower, T upper, int mask, Class<T> clazz) {
        this.lower = lower;
        this.upper = upper;
        this.mask = mask;
        this.clazz = clazz;
        if (this.isBounded() && lower != null && upper != null && lower.compareTo(upper) > 0) {
            throw new IllegalArgumentException("The lower bound is greater then upper!");
        }
    }

    public static <T extends Comparable<? super T>> Range<T> closed(T lower, T upper) {
        Objects.requireNonNull(lower);
        Objects.requireNonNull(upper);
        return new Range<T>(lower, upper, 10, lower.getClass());
    }

    public static <T extends Comparable<? super T>> Range<T> open(T lower, T upper) {
        Objects.requireNonNull(lower);
        Objects.requireNonNull(upper);
        return new Range<T>(lower, upper, 20, lower.getClass());
    }

    public static <T extends Comparable<? super T>> Range<T> openClosed(T lower, T upper) {
        Objects.requireNonNull(lower);
        Objects.requireNonNull(upper);
        return new Range<T>(lower, upper, 12, lower.getClass());
    }

    public static <T extends Comparable<? super T>> Range<T> closedOpen(T lower, T upper) {
        Objects.requireNonNull(lower);
        Objects.requireNonNull(upper);
        return new Range<T>(lower, upper, 18, lower.getClass());
    }

    public static <T extends Comparable<? super T>> Range<T> openInfinite(T lower) {
        Objects.requireNonNull(lower);
        return new Range<Object>(lower, null, 84, (Class<Object>)lower.getClass());
    }

    public static <T extends Comparable<? super T>> Range<T> closedInfinite(T lower) {
        Objects.requireNonNull(lower);
        return new Range<Object>(lower, null, 82, (Class<Object>)lower.getClass());
    }

    public static <T extends Comparable<? super T>> Range<T> infiniteOpen(T upper) {
        Objects.requireNonNull(upper);
        return new Range<Object>(null, upper, 52, (Class<Object>)upper.getClass());
    }

    public static <T extends Comparable<? super T>> Range<T> infiniteClosed(T upper) {
        Objects.requireNonNull(upper);
        return new Range<Object>(null, upper, 44, (Class<Object>)upper.getClass());
    }

    public static <T extends Comparable<? super T>> Range<T> infinite(Class<T> cls) {
        return new Range<Object>(null, null, 116, cls);
    }

    public static <R extends Comparable<? super R>> Range<R> emptyRange(Class<R> cls) {
        return new Range<Object>(null, null, 20, cls);
    }

    public static <T extends Comparable<? super T>> Range<T> ofString(String str, Function<String, T> converter, Class<T> clazz) {
        if (str.equals(EMPTY)) {
            return Range.emptyRange(clazz);
        }
        int mask = str.charAt(0) == '[' ? 2 : 4;
        mask |= str.charAt(str.length() - 1) == ']' ? 8 : 16;
        int delim = str.indexOf(44);
        if (delim == -1) {
            throw new IllegalArgumentException("Cannot find comma character");
        }
        String lowerStr = str.substring(1, delim);
        String upperStr = str.substring(delim + 1, str.length() - 1);
        if (lowerStr.length() == 0 || lowerStr.endsWith(INFINITY)) {
            mask |= 0x24;
        }
        if (upperStr.length() == 0 || upperStr.endsWith(INFINITY)) {
            mask |= 0x50;
        }
        Comparable lower = null;
        Comparable upper = null;
        if ((mask & 0x24) != 36) {
            lower = (Comparable)converter.apply(lowerStr);
        }
        if ((mask & 0x50) != 80) {
            upper = (Comparable)converter.apply(upperStr);
        }
        return new Range<Comparable>(lower, upper, mask, clazz);
    }

    public static Range<BigDecimal> bigDecimalRange(String range) {
        return Range.ofString(range, BigDecimal::new, BigDecimal.class);
    }

    public static Range<Integer> integerRange(String range) {
        return Range.ofString(range, Integer::parseInt, Integer.class);
    }

    public static Range<Long> longRange(String range) {
        return Range.ofString(range, Long::parseLong, Long.class);
    }

    public static Range<LocalDateTime> localDateTimeRange(String range) {
        return Range.ofString(range, Range.parseLocalDateTime().compose(Range.unquote()), LocalDateTime.class);
    }

    public static Range<LocalDate> localDateRange(String range) {
        Function<String, LocalDate> parseLocalDate = LocalDate::parse;
        return Range.ofString(range, parseLocalDate.compose(Range.unquote()), LocalDate.class);
    }

    public static Range<ZonedDateTime> zonedDateTimeRange(String rangeStr) {
        ZoneId upperZone;
        ZoneId lowerZone;
        Range<ZonedDateTime> range = Range.ofString(rangeStr, Range.parseZonedDateTime().compose(Range.unquote()), ZonedDateTime.class);
        if (range.hasLowerBound() && range.hasUpperBound() && !(lowerZone = range.lower().getZone()).equals(upperZone = range.upper().getZone())) {
            long zoneDriftSeconds;
            Duration lowerDst = ZoneId.systemDefault().getRules().getDaylightSavings(range.lower().toInstant());
            Duration upperDst = ZoneId.systemDefault().getRules().getDaylightSavings(range.upper().toInstant());
            long dstSeconds = upperDst.minus(lowerDst).getSeconds();
            if (dstSeconds < 0L) {
                dstSeconds *= -1L;
            }
            if ((zoneDriftSeconds = (long)(((ZoneOffset)lowerZone).getTotalSeconds() - ((ZoneOffset)upperZone).getTotalSeconds())) < 0L) {
                zoneDriftSeconds *= -1L;
            }
            if (dstSeconds != zoneDriftSeconds) {
                throw new IllegalArgumentException("The upper and lower bounds must be in same time zone!");
            }
        }
        return range;
    }

    private static Function<String, LocalDateTime> parseLocalDateTime() {
        return s -> {
            try {
                return LocalDateTime.parse(s, LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                return LocalDateTime.parse(s);
            }
        };
    }

    private static Function<String, ZonedDateTime> parseZonedDateTime() {
        return s -> {
            try {
                return ZonedDateTime.parse(s, ZONE_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                return ZonedDateTime.parse(s);
            }
        };
    }

    private static Function<String, String> unquote() {
        return s -> {
            if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
                return s.substring(1, s.length() - 1);
            }
            return s;
        };
    }

    private boolean isBounded() {
        return !this.hasMask(36) && !this.hasMask(80);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return this.mask == range.mask && Objects.equals(this.lower, range.lower) && Objects.equals(this.upper, range.upper) && Objects.equals(this.clazz, range.clazz);
    }

    public int hashCode() {
        return Objects.hash(this.lower, this.upper, this.mask, this.clazz);
    }

    public String toString() {
        return "Range{lower=" + this.lower + ", upper=" + this.upper + ", mask=" + this.mask + ", clazz=" + this.clazz + "}";
    }

    public boolean hasMask(int flag) {
        return (this.mask & flag) == flag;
    }

    public boolean isLowerBoundClosed() {
        return this.hasLowerBound() && this.hasMask(2);
    }

    public boolean isUpperBoundClosed() {
        return this.hasUpperBound() && this.hasMask(8);
    }

    public boolean hasLowerBound() {
        return !this.hasMask(36);
    }

    public boolean hasUpperBound() {
        return !this.hasMask(80);
    }

    public T lower() {
        return this.lower;
    }

    public T upper() {
        return this.upper;
    }

    public boolean contains(T point) {
        if (this.isEmpty()) {
            return false;
        }
        boolean l = this.hasLowerBound();
        boolean u = this.hasUpperBound();
        if (l && u) {
            boolean inLower;
            boolean bl = this.hasMask(2) ? this.lower.compareTo(point) <= 0 : (inLower = this.lower.compareTo(point) < 0);
            boolean inUpper = this.hasMask(8) ? this.upper.compareTo(point) >= 0 : this.upper.compareTo(point) > 0;
            return inLower && inUpper;
        }
        if (l) {
            return this.hasMask(2) ? this.lower.compareTo(point) <= 0 : this.lower.compareTo(point) < 0;
        }
        if (u) {
            return this.hasMask(8) ? this.upper.compareTo(point) >= 0 : this.upper.compareTo(point) > 0;
        }
        return true;
    }

    public boolean contains(Range<T> range) {
        return !(this.isEmpty() || range.hasLowerBound() && !this.contains(range.lower) || range.hasUpperBound() && !this.contains(range.upper));
    }

    public boolean isEmpty() {
        return this.isBoundedOpen() && this.hasEqualBounds();
    }

    private boolean hasEqualBounds() {
        return this.lower == null && this.upper == null || this.lower != null && this.upper != null && this.lower.compareTo(this.upper) == 0;
    }

    private boolean isBoundedOpen() {
        return this.isBounded() && !this.isLowerBoundClosed() && !this.isUpperBoundClosed();
    }

    public String asString() {
        if (this.lower == null && this.upper == null && this.isBoundedOpen()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.hasMask(2) ? (char)'[' : '(').append(this.hasLowerBound() ? this.boundToString().apply(this.lower) : "").append(",").append(this.hasUpperBound() ? this.boundToString().apply(this.upper) : "").append(this.hasMask(8) ? (char)']' : ')');
        return sb.toString();
    }

    private Function<T, String> boundToString() {
        return t -> {
            if (this.clazz.equals(ZonedDateTime.class)) {
                return ZONE_DATE_TIME.format((ZonedDateTime)t);
            }
            return t.toString();
        };
    }

    Class<T> getClazz() {
        return this.clazz;
    }
}

