/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type;

import com.vladmihalcea.hibernate.type.array.BooleanArrayType;
import com.vladmihalcea.hibernate.type.array.DateArrayType;
import com.vladmihalcea.hibernate.type.array.DecimalArrayType;
import com.vladmihalcea.hibernate.type.array.DoubleArrayType;
import com.vladmihalcea.hibernate.type.array.EnumArrayType;
import com.vladmihalcea.hibernate.type.array.IntArrayType;
import com.vladmihalcea.hibernate.type.array.LocalDateArrayType;
import com.vladmihalcea.hibernate.type.array.LocalDateTimeArrayType;
import com.vladmihalcea.hibernate.type.array.LongArrayType;
import com.vladmihalcea.hibernate.type.array.StringArrayType;
import com.vladmihalcea.hibernate.type.array.TimestampArrayType;
import com.vladmihalcea.hibernate.type.array.UUIDArrayType;
import com.vladmihalcea.hibernate.type.basic.Iso8601MonthType;
import com.vladmihalcea.hibernate.type.basic.MonthDayDateType;
import com.vladmihalcea.hibernate.type.basic.MonthDayIntegerType;
import com.vladmihalcea.hibernate.type.basic.NullableCharacterType;
import com.vladmihalcea.hibernate.type.basic.PostgreSQLEnumType;
import com.vladmihalcea.hibernate.type.basic.PostgreSQLHStoreType;
import com.vladmihalcea.hibernate.type.basic.PostgreSQLInetType;
import com.vladmihalcea.hibernate.type.basic.YearMonthDateType;
import com.vladmihalcea.hibernate.type.basic.YearMonthEpochType;
import com.vladmihalcea.hibernate.type.basic.YearMonthIntegerType;
import com.vladmihalcea.hibernate.type.basic.YearMonthTimestampType;
import com.vladmihalcea.hibernate.type.interval.OracleIntervalDayToSecondType;
import com.vladmihalcea.hibernate.type.interval.PostgreSQLIntervalType;
import com.vladmihalcea.hibernate.type.interval.PostgreSQLPeriodType;
import com.vladmihalcea.hibernate.type.json.JsonNodeStringType;
import com.vladmihalcea.hibernate.type.range.PostgreSQLRangeType;
import com.vladmihalcea.hibernate.type.range.guava.PostgreSQLGuavaRangeType;
import com.vladmihalcea.hibernate.util.ReflectionUtils;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.usertype.UserType;

public class HibernateTypesContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        boolean enableJson;
        JdbcServices jdbcServices = (JdbcServices)serviceRegistry.getService(JdbcServices.class);
        Dialect dialect = jdbcServices.getDialect();
        boolean bl = enableJson = ReflectionUtils.getClassOrNull("com.fasterxml.jackson.databind.ObjectMapper") != null;
        if (dialect instanceof PostgreSQLDialect) {
            typeContributions.contributeType((UserType)BooleanArrayType.INSTANCE);
            typeContributions.contributeType((UserType)DateArrayType.INSTANCE);
            typeContributions.contributeType((UserType)DecimalArrayType.INSTANCE);
            typeContributions.contributeType((UserType)DoubleArrayType.INSTANCE);
            typeContributions.contributeType((UserType)EnumArrayType.INSTANCE);
            typeContributions.contributeType((UserType)IntArrayType.INSTANCE);
            typeContributions.contributeType((UserType)LocalDateArrayType.INSTANCE);
            typeContributions.contributeType((UserType)LocalDateTimeArrayType.INSTANCE);
            typeContributions.contributeType((UserType)LongArrayType.INSTANCE);
            typeContributions.contributeType((UserType)StringArrayType.INSTANCE);
            typeContributions.contributeType((UserType)TimestampArrayType.INSTANCE);
            typeContributions.contributeType((UserType)UUIDArrayType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLIntervalType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLPeriodType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLEnumType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLHStoreType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLInetType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLRangeType.INSTANCE);
            if (ReflectionUtils.getClassOrNull("com.google.common.collect.Range") != null) {
                typeContributions.contributeType((UserType)PostgreSQLGuavaRangeType.INSTANCE);
            }
        } else if (dialect instanceof MySQLDialect) {
            if (enableJson) {
                typeContributions.contributeType((UserType)JsonNodeStringType.INSTANCE);
            }
        } else if (dialect instanceof OracleDialect) {
            typeContributions.contributeType((UserType)OracleIntervalDayToSecondType.INSTANCE);
        }
        typeContributions.contributeType((UserType)NullableCharacterType.INSTANCE);
        typeContributions.contributeType((UserType)Iso8601MonthType.INSTANCE);
        typeContributions.contributeType((UserType)MonthDayDateType.INSTANCE);
        typeContributions.contributeType((UserType)MonthDayIntegerType.INSTANCE);
        typeContributions.contributeType((UserType)YearMonthDateType.INSTANCE);
        typeContributions.contributeType((UserType)YearMonthEpochType.INSTANCE);
        typeContributions.contributeType((UserType)YearMonthIntegerType.INSTANCE);
        typeContributions.contributeType((UserType)YearMonthTimestampType.INSTANCE);
    }
}

