/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.naming;

import com.vladmihalcea.hibernate.type.util.Configuration;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;

public class CamelCaseToSnakeCaseNamingStrategy
extends PhysicalNamingStrategyStandardImpl {
    public static final CamelCaseToSnakeCaseNamingStrategy INSTANCE = new CamelCaseToSnakeCaseNamingStrategy();
    public static final String CAMEL_CASE_REGEX = "([a-z]+)([A-Z]+)";
    public static final String SNAKE_CASE_PATTERN = "$1\\_$2";
    private final Configuration configuration;

    public CamelCaseToSnakeCaseNamingStrategy() {
        this.configuration = Configuration.INSTANCE;
    }

    public CamelCaseToSnakeCaseNamingStrategy(Configuration configuration) {
        this.configuration = configuration;
    }

    public Identifier toPhysicalCatalogName(Identifier name, JdbcEnvironment context) {
        return this.formatIdentifier(super.toPhysicalCatalogName(name, context));
    }

    public Identifier toPhysicalSchemaName(Identifier name, JdbcEnvironment context) {
        return this.formatIdentifier(super.toPhysicalSchemaName(name, context));
    }

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment context) {
        return this.formatIdentifier(super.toPhysicalTableName(name, context));
    }

    public Identifier toPhysicalSequenceName(Identifier name, JdbcEnvironment context) {
        return this.formatIdentifier(super.toPhysicalSequenceName(name, context));
    }

    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment context) {
        return this.formatIdentifier(super.toPhysicalColumnName(name, context));
    }

    private Identifier formatIdentifier(Identifier identifier) {
        if (identifier != null) {
            String name = identifier.getText();
            String formattedName = name.replaceAll(CAMEL_CASE_REGEX, SNAKE_CASE_PATTERN).toLowerCase();
            return !formattedName.equals(name) ? Identifier.toIdentifier((String)formattedName, (boolean)identifier.isQuoted()) : identifier;
        }
        return null;
    }
}

