/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.named.RowReaderMemento;
import org.hibernate.sql.results.LoadingLogger;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.type.descriptor.java.JavaType;

public class StandardRowReader<T>
implements RowReader<T> {
    private final List<DomainResultAssembler<?>> resultAssemblers;
    private final List<Initializer> initializers;
    private final RowTransformer<T> rowTransformer;
    private final Class<T> domainResultJavaType;
    private final int assemblerCount;

    public StandardRowReader(List<DomainResultAssembler<?>> resultAssemblers, List<Initializer> initializers, RowTransformer<T> rowTransformer, Class<T> domainResultJavaType) {
        this.resultAssemblers = resultAssemblers;
        this.initializers = initializers;
        this.rowTransformer = rowTransformer;
        this.assemblerCount = resultAssemblers.size();
        this.domainResultJavaType = domainResultJavaType;
        this.logDebugInfo();
    }

    protected void logDebugInfo() {
    }

    @Override
    public Class<T> getDomainResultResultJavaType() {
        return this.domainResultJavaType;
    }

    @Override
    public Class<?> getResultJavaType() {
        if (this.resultAssemblers.size() == 1) {
            return this.resultAssemblers.get(0).getAssembledJavaType().getJavaTypeClass();
        }
        return Object[].class;
    }

    @Override
    public List<JavaType<?>> getResultJavaTypes() {
        ArrayList javaTypes = new ArrayList(this.resultAssemblers.size());
        for (DomainResultAssembler<?> resultAssembler : this.resultAssemblers) {
            javaTypes.add(resultAssembler.getAssembledJavaType());
        }
        return javaTypes;
    }

    @Override
    public List<Initializer> getInitializers() {
        return this.initializers;
    }

    @Override
    public T readRow(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        LoadingLogger.LOGGER.trace((Object)"StandardRowReader#readRow");
        this.coordinateInitializers(rowProcessingState);
        Object[] resultRow = new Object[this.assemblerCount];
        for (int i = 0; i < this.assemblerCount; ++i) {
            DomainResultAssembler<?> assembler = this.resultAssemblers.get(i);
            LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, assembler);
            resultRow[i] = assembler.assemble(rowProcessingState, options);
        }
        this.afterRow(rowProcessingState);
        return this.rowTransformer.transformRow(resultRow);
    }

    private void afterRow(RowProcessingState rowProcessingState) {
        LoadingLogger.LOGGER.trace((Object)"StandardRowReader#afterRow");
        this.initializers.forEach(initializer -> initializer.finishUpRow(rowProcessingState));
    }

    private void coordinateInitializers(RowProcessingState rowProcessingState) {
        Initializer initializer;
        int i;
        int numberOfInitializers = this.initializers.size();
        for (i = 0; i < numberOfInitializers; ++i) {
            initializer = this.initializers.get(i);
            if (initializer.isCollectionInitializer()) continue;
            initializer.resolveKey(rowProcessingState);
        }
        for (i = 0; i < numberOfInitializers; ++i) {
            initializer = this.initializers.get(i);
            if (!initializer.isCollectionInitializer()) continue;
            initializer.resolveKey(rowProcessingState);
        }
        for (i = 0; i < numberOfInitializers; ++i) {
            initializer = this.initializers.get(i);
            if (initializer instanceof EntityDelayedFetchInitializer) continue;
            initializer.resolveInstance(rowProcessingState);
        }
        for (i = 0; i < numberOfInitializers; ++i) {
            initializer = this.initializers.get(i);
            if (!(initializer instanceof EntityDelayedFetchInitializer)) continue;
            initializer.resolveInstance(rowProcessingState);
        }
        for (i = 0; i < numberOfInitializers; ++i) {
            this.initializers.get(i).initializeInstance(rowProcessingState);
        }
    }

    @Override
    public void finishUp(JdbcValuesSourceProcessingState processingState) {
        for (int i = 0; i < this.initializers.size(); ++i) {
            this.initializers.get(i).endLoading(processingState.getExecutionContext());
        }
    }

    @Override
    public RowReaderMemento toMemento(SessionFactoryImplementor factory) {
        return new RowReaderMemento(){

            @Override
            public Class<?>[] getResultClasses() {
                return ArrayHelper.EMPTY_CLASS_ARRAY;
            }

            @Override
            public String[] getResultMappingNames() {
                return ArrayHelper.EMPTY_STRING_ARRAY;
            }
        };
    }
}

