/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.Type;

public class EntityDelayedFetchInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final FetchParentAccess parentAccess;
    private final NavigablePath navigablePath;
    private final ToOneAttributeMapping referencedModelPart;
    private final boolean selectByUniqueKey;
    private final DomainResultAssembler<?> identifierAssembler;
    private Object entityInstance;
    private Object identifier;

    public EntityDelayedFetchInitializer(FetchParentAccess parentAccess, NavigablePath fetchedNavigable, ToOneAttributeMapping referencedModelPart, boolean selectByUniqueKey, DomainResultAssembler<?> identifierAssembler) {
        assert (referencedModelPart.getNotFoundAction() == null);
        this.parentAccess = parentAccess;
        this.navigablePath = fetchedNavigable;
        this.referencedModelPart = referencedModelPart;
        this.selectByUniqueKey = selectByUniqueKey;
        this.identifierAssembler = identifierAssembler;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null) {
            return;
        }
        EntityInitializer parentEntityInitializer = this.getParentEntityInitializer(this.parentAccess);
        if (parentEntityInitializer != null && parentEntityInitializer.isInitialized()) {
            return;
        }
        if (!this.isAttributeAssignableToConcreteDescriptor(this.parentAccess, this.referencedModelPart)) {
            return;
        }
        this.identifier = this.identifierAssembler.assemble(rowProcessingState);
        if (this.identifier == null) {
            this.entityInstance = null;
        } else {
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            EntityPersister concreteDescriptor = this.referencedModelPart.getEntityMappingType().getEntityPersister();
            if (!this.selectByUniqueKey) {
                EntityKey entityKey = new EntityKey(this.identifier, concreteDescriptor);
                PersistenceContext persistenceContext = session.getPersistenceContext();
                LoadingEntityEntry loadingEntityLocally = persistenceContext.getLoadContexts().findLoadingEntityEntry(entityKey);
                if (loadingEntityLocally != null) {
                    this.entityInstance = loadingEntityLocally.getEntityInstance();
                }
                if (this.entityInstance == null) {
                    this.entityInstance = persistenceContext.getEntity(entityKey);
                    if (this.entityInstance != null) {
                        this.entityInstance = persistenceContext.proxyFor(this.entityInstance);
                    }
                }
            }
            if (this.entityInstance == null) {
                if (this.referencedModelPart.isOptional() && this.parentAccess != null && !this.parentAccess.isEmbeddableInitializer() && EntityDelayedFetchInitializer.isEnhancedForLazyLoading(parentEntityInitializer)) {
                    this.entityInstance = LazyPropertyInitializer.UNFETCHED_PROPERTY;
                } else {
                    if (this.selectByUniqueKey) {
                        String uniqueKeyPropertyName = this.referencedModelPart.getReferencedPropertyName();
                        Type uniqueKeyPropertyType = this.referencedModelPart.getReferencedPropertyName() == null ? concreteDescriptor.getIdentifierType() : session.getFactory().getReferencedPropertyType(concreteDescriptor.getEntityName(), uniqueKeyPropertyName);
                        EntityUniqueKey euk = new EntityUniqueKey(concreteDescriptor.getEntityName(), uniqueKeyPropertyName, this.identifier, uniqueKeyPropertyType, session.getFactory());
                        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
                        this.entityInstance = persistenceContext.getEntity(euk);
                        if (this.entityInstance == null) {
                            if (this.parentAccess != null && !this.parentAccess.isEmbeddableInitializer() && EntityDelayedFetchInitializer.isEnhancedForLazyLoading(parentEntityInitializer)) {
                                return;
                            }
                            this.entityInstance = ((UniqueKeyLoadable)concreteDescriptor).loadByUniqueKey(uniqueKeyPropertyName, this.identifier, session);
                            if (this.entityInstance != null) {
                                persistenceContext.addEntity(euk, this.entityInstance);
                            }
                        }
                        if (this.entityInstance != null) {
                            this.entityInstance = persistenceContext.proxyFor(this.entityInstance);
                        }
                    } else {
                        this.entityInstance = session.internalLoad(concreteDescriptor.getEntityName(), this.identifier, false, false);
                    }
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
                    if (lazyInitializer != null) {
                        lazyInitializer.setUnwrap(this.referencedModelPart.isUnwrapProxy() && concreteDescriptor.isInstrumented());
                    }
                }
            }
            this.notifyResolutionListeners(this.entityInstance);
        }
    }

    private EntityInitializer getParentEntityInitializer(FetchParentAccess parentAccess) {
        if (parentAccess != null) {
            return parentAccess.findFirstEntityInitializer();
        }
        return null;
    }

    private static boolean isEnhancedForLazyLoading(EntityInitializer parentEntityIntialiazer) {
        return parentEntityIntialiazer != null && parentEntityIntialiazer.getEntityDescriptor().getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.identifier = null;
        this.clearResolutionListeners();
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.referencedModelPart.getEntityMappingType().getEntityPersister();
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public EntityKey getEntityKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getParentKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstance != null) {
            listener.accept(this.entityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.getEntityDescriptor();
    }

    public String toString() {
        return "EntityDelayedFetchInitializer(" + LoggingHelper.toLoggableString(this.navigablePath) + ")";
    }
}

