/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractFetchParent
implements FetchParent {
    private final FetchableContainer fetchContainer;
    private final NavigablePath navigablePath;
    private List<Fetch> fetches;

    public AbstractFetchParent(FetchableContainer fetchContainer, NavigablePath navigablePath) {
        this.fetchContainer = fetchContainer;
        this.navigablePath = navigablePath;
    }

    public void afterInitialize(FetchParent fetchParent, DomainResultCreationState creationState) {
        assert (this.fetches == null);
        this.resetFetches(creationState.visitFetches(fetchParent));
    }

    protected void resetFetches(List<Fetch> newFetches) {
        this.fetches = Collections.unmodifiableList(newFetches);
    }

    public FetchableContainer getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.fetchContainer.getJavaType();
    }

    @Override
    public FetchableContainer getReferencedMappingContainer() {
        return this.fetchContainer;
    }

    @Override
    public List<Fetch> getFetches() {
        return this.fetches == null ? Collections.emptyList() : this.fetches;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        if (this.fetches == null) {
            return null;
        }
        for (int i = 0; i < this.fetches.size(); ++i) {
            Fetch fetch = this.fetches.get(i);
            if (fetchable != fetch.getFetchedMapping()) continue;
            return fetch;
        }
        if (fetchable instanceof EntityVersionMapping) {
            NavigableRole navigableRole = fetchable.getNavigableRole();
            for (int i = 0; i < this.fetches.size(); ++i) {
                Fetch fetch = this.fetches.get(i);
                if (!fetch.getFetchedMapping().getNavigableRole().equals(navigableRole)) continue;
                return fetch;
            }
        }
        return null;
    }
}

