/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmComparisonPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> leftHandExpression;
    private ComparisonOperator operator;
    private final SqmExpression<?> rightHandExpression;

    public SqmComparisonPredicate(SqmExpression<?> leftHandExpression, ComparisonOperator operator, SqmExpression<?> rightHandExpression, NodeBuilder nodeBuilder) {
        this(leftHandExpression, operator, rightHandExpression, false, nodeBuilder);
    }

    private SqmComparisonPredicate(SqmExpression<?> leftHandExpression, ComparisonOperator operator, SqmExpression<?> rightHandExpression, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.leftHandExpression = leftHandExpression;
        this.rightHandExpression = rightHandExpression;
        this.operator = operator;
        SqmExpressible expressibleType = QueryHelper.highestPrecedenceType(leftHandExpression.getNodeType(), rightHandExpression.getNodeType());
        leftHandExpression.applyInferableType(expressibleType);
        rightHandExpression.applyInferableType(expressibleType);
    }

    private SqmComparisonPredicate(SqmComparisonPredicate affirmativeForm) {
        super(true, (NodeBuilder)affirmativeForm.nodeBuilder());
        this.leftHandExpression = affirmativeForm.leftHandExpression;
        this.rightHandExpression = affirmativeForm.rightHandExpression;
        this.operator = affirmativeForm.operator;
    }

    @Override
    public SqmComparisonPredicate copy(SqmCopyContext context) {
        SqmComparisonPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmComparisonPredicate predicate = context.registerCopy(this, new SqmComparisonPredicate((SqmExpression<?>)this.leftHandExpression.copy(context), this.operator, (SqmExpression<?>)this.rightHandExpression.copy(context), this.isNegated(), this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmExpression<?> getLeftHandExpression() {
        return this.leftHandExpression;
    }

    public SqmExpression<?> getRightHandExpression() {
        return this.rightHandExpression;
    }

    public ComparisonOperator getSqmOperator() {
        return this.operator;
    }

    @Override
    public void negate() {
        this.operator = this.operator.negated();
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmComparisonPredicate(this);
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitComparisonPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.leftHandExpression.appendHqlString(sb);
        sb.append(' ');
        sb.append(this.operator.sqlText());
        sb.append(' ');
        this.rightHandExpression.appendHqlString(sb);
    }
}

