/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import org.hibernate.LockOptions;
import org.hibernate.query.spi.DelegatingQueryOptions;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class SqlOmittingQueryOptions
extends DelegatingQueryOptions {
    private final boolean omitLimit;
    private final boolean omitLocks;
    private final ListResultsConsumer.UniqueSemantic uniqueSemantic;

    public SqlOmittingQueryOptions(QueryOptions queryOptions, boolean omitLimit, boolean omitLocks) {
        super(queryOptions);
        this.omitLimit = omitLimit;
        this.omitLocks = omitLocks;
        this.uniqueSemantic = null;
    }

    public SqlOmittingQueryOptions(QueryOptions queryOptions, boolean omitLimit, boolean omitLocks, ListResultsConsumer.UniqueSemantic semantic) {
        super(queryOptions);
        this.omitLimit = omitLimit;
        this.omitLocks = omitLocks;
        this.uniqueSemantic = semantic;
    }

    public static QueryOptions omitSqlQueryOptions(QueryOptions originalOptions) {
        return SqlOmittingQueryOptions.omitSqlQueryOptions(originalOptions, true, true);
    }

    public static QueryOptions omitSqlQueryOptions(QueryOptions originalOptions, JdbcSelect select) {
        return SqlOmittingQueryOptions.omitSqlQueryOptions(originalOptions, !select.usesLimitParameters(), false);
    }

    public static QueryOptions omitSqlQueryOptions(QueryOptions originalOptions, boolean omitLimit, boolean omitLocks) {
        Limit limit = originalOptions.getLimit();
        if (originalOptions.getLockOptions().isEmpty() && (!omitLimit || limit == null || limit.isEmpty())) {
            return originalOptions;
        }
        if (!(omitLocks || omitLimit && limit != null && !limit.isEmpty())) {
            return originalOptions;
        }
        return new SqlOmittingQueryOptions(originalOptions, omitLimit, omitLocks);
    }

    public static QueryOptions omitSqlQueryOptionsWithUniqueSemanticFilter(QueryOptions originalOptions, boolean omitLimit, boolean omitLocks) {
        Limit limit = originalOptions.getLimit();
        if (originalOptions.getLockOptions().isEmpty() && (!omitLimit || limit == null || limit.isEmpty())) {
            return originalOptions;
        }
        if (!(omitLocks || omitLimit && limit != null && !limit.isEmpty())) {
            return originalOptions;
        }
        return new SqlOmittingQueryOptions(originalOptions, omitLimit, omitLocks, ListResultsConsumer.UniqueSemantic.FILTER);
    }

    @Override
    public LockOptions getLockOptions() {
        return this.omitLocks ? LockOptions.NONE : super.getLockOptions();
    }

    @Override
    public Integer getFetchSize() {
        return null;
    }

    @Override
    public Limit getLimit() {
        return this.omitLimit ? Limit.NONE : super.getLimit();
    }

    @Override
    public Integer getFirstRow() {
        return this.omitLimit ? null : super.getFirstRow();
    }

    @Override
    public Integer getMaxRows() {
        return this.omitLimit ? null : super.getMaxRows();
    }

    @Override
    public Limit getEffectiveLimit() {
        return this.omitLimit ? Limit.NONE : super.getEffectiveLimit();
    }

    @Override
    public boolean hasLimit() {
        return this.omitLimit ? false : super.hasLimit();
    }

    @Override
    public ListResultsConsumer.UniqueSemantic getUniqueSemantic() {
        return this.uniqueSemantic;
    }
}

