/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.AttributeMetadataAccess;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.NoValueGeneration;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.spi.TreatedNavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.CorrelatedTableGroup;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.MappedByTableGroup;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedResultImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchJoinedImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchSelectImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityResultImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityResultJoinedSubclassImpl;
import org.hibernate.sql.results.graph.entity.internal.NotFoundSnapshotResult;
import org.hibernate.sql.results.internal.domain.CircularBiDirectionalFetchImpl;
import org.hibernate.sql.results.internal.domain.CircularFetchImpl;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ToOneAttributeMapping
extends AbstractSingularAttributeMapping
implements EntityValuedFetchable,
EntityAssociationMapping,
TableGroupJoinProducer {
    private final NavigableRole navigableRole;
    private final String sqlAliasStem;
    private final boolean isNullable;
    private final boolean isKeyTableNullable;
    private final boolean isInternalLoadNullable;
    private final NotFoundAction notFoundAction;
    private final boolean unwrapProxy;
    private final boolean isOptional;
    private final EntityMappingType entityMappingType;
    private final String referencedPropertyName;
    private final String targetKeyPropertyName;
    private final Set<String> targetKeyPropertyNames;
    private final Cardinality cardinality;
    private final String bidirectionalAttributeName;
    private final TableGroupProducer declaringTableGroupProducer;
    private ForeignKeyDescriptor foreignKeyDescriptor;
    private ForeignKeyDescriptor.Nature sideNature;
    private String identifyingColumnsTableExpression;
    private boolean canUseParentTableGroup;

    public ToOneAttributeMapping(String name, NavigableRole navigableRole, int stateArrayPosition, ToOne bootValue, AttributeMetadataAccess attributeMetadataAccess, FetchOptions mappedFetchOptions, EntityMappingType entityMappingType, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, PropertyAccess propertyAccess) {
        this(name, navigableRole, stateArrayPosition, bootValue, attributeMetadataAccess, mappedFetchOptions.getTiming(), mappedFetchOptions.getStyle(), entityMappingType, declaringType, declaringEntityPersister, propertyAccess);
    }

    public ToOneAttributeMapping(String name, NavigableRole navigableRole, int stateArrayPosition, ToOne bootValue, AttributeMetadataAccess attributeMetadataAccess, FetchTiming mappedFetchTiming, FetchStyle mappedFetchStyle, EntityMappingType entityMappingType, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, PropertyAccess propertyAccess) {
        super(name, stateArrayPosition, attributeMetadataAccess, ToOneAttributeMapping.adjustFetchTiming(mappedFetchTiming, bootValue), mappedFetchStyle, declaringType, propertyAccess, NoValueGeneration.INSTANCE);
        HashSet<String> targetKeyPropertyNames;
        PersistentClass entityBinding;
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(name);
        this.isNullable = bootValue.isNullable();
        this.referencedPropertyName = bootValue.getReferencedPropertyName();
        this.unwrapProxy = bootValue.isUnwrapProxy();
        this.entityMappingType = entityMappingType;
        if (bootValue instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)bootValue;
            this.notFoundAction = ((ManyToOne)bootValue).getNotFoundAction();
            this.cardinality = manyToOne.isLogicalOneToOne() ? Cardinality.LOGICAL_ONE_TO_ONE : Cardinality.MANY_TO_ONE;
            entityBinding = manyToOne.getMetadata().getEntityBinding(manyToOne.getReferencedEntityName());
            if (this.referencedPropertyName == null) {
                Property property;
                Iterator<Property> propertyClosureIterator;
                String bidirectionalAttributeName = null;
                if (this.cardinality == Cardinality.LOGICAL_ONE_TO_ONE) {
                    for (Join join : entityBinding.getJoinClosure()) {
                        if (!join.getPersistentClass().getEntityName().equals(entityBinding.getEntityName()) || join.getPropertySpan() != 1 || join.getTable() != manyToOne.getTable() || !ToOneAttributeMapping.equal(join.getKey(), manyToOne)) continue;
                        bidirectionalAttributeName = join.getPropertyIterator().next().getName();
                        break;
                    }
                    if (bidirectionalAttributeName == null) {
                        propertyClosureIterator = entityBinding.getPropertyClosureIterator();
                        while (propertyClosureIterator.hasNext()) {
                            property = propertyClosureIterator.next();
                            if (!(property.getValue() instanceof OneToOne) || !name.equals(((OneToOne)property.getValue()).getMappedByProperty()) || !((OneToOne)property.getValue()).getReferencedEntityName().equals(declaringType.getJavaType().getJavaType().getTypeName())) continue;
                            bidirectionalAttributeName = property.getName();
                            break;
                        }
                    }
                } else {
                    propertyClosureIterator = entityBinding.getPropertyClosureIterator();
                    while (propertyClosureIterator.hasNext()) {
                        property = propertyClosureIterator.next();
                        Value value = property.getValue();
                        if (!(value instanceof Collection) || !name.equals(((Collection)value).getMappedByProperty()) || !((Collection)value).getElement().getType().getName().equals(declaringType.getJavaType().getJavaType().getTypeName())) continue;
                        bidirectionalAttributeName = property.getName();
                        break;
                    }
                }
                this.bidirectionalAttributeName = bidirectionalAttributeName;
            } else {
                Property property = entityBinding.getProperty(this.referencedPropertyName);
                String string = this.bidirectionalAttributeName = property != null && property.getValue() instanceof EntityType ? this.referencedPropertyName : null;
            }
            if (bootValue.isNullable()) {
                this.isKeyTableNullable = true;
            } else {
                String targetTableName = MappingModelCreationHelper.getTableIdentifierExpression(manyToOne.getTable(), declaringEntityPersister.getFactory());
                if (CollectionPart.Nature.fromNameExact(navigableRole.getParent().getLocalName()) != null) {
                    PluralAttributeMapping pluralAttribute = (PluralAttributeMapping)declaringEntityPersister.findByPath(navigableRole.getParent().getParent().getFullPath().substring(declaringEntityPersister.getNavigableRole().getFullPath().length() + 1));
                    assert (pluralAttribute != null);
                    QueryableCollection persister = (QueryableCollection)pluralAttribute.getCollectionDescriptor();
                    this.isKeyTableNullable = !persister.getTableName().equals(targetTableName);
                } else {
                    AbstractEntityPersister persister = (AbstractEntityPersister)declaringEntityPersister;
                    int tableIndex = ArrayHelper.indexOf(persister.getTableNames(), targetTableName);
                    this.isKeyTableNullable = persister.isNullableTable(tableIndex);
                }
            }
            this.isOptional = ((ManyToOne)bootValue).isIgnoreNotFound();
            this.isInternalLoadNullable = this.isNullable && bootValue.isForeignKeyEnabled() || this.notFoundAction == NotFoundAction.IGNORE;
        } else {
            assert (bootValue instanceof OneToOne);
            this.cardinality = Cardinality.ONE_TO_ONE;
            OneToOne oneToOne = (OneToOne)bootValue;
            String bidirectionalAttributeName = StringHelper.subStringNullIfEmpty(oneToOne.getMappedByProperty(), Character.valueOf('.'));
            this.bidirectionalAttributeName = bidirectionalAttributeName == null ? StringHelper.subStringNullIfEmpty(this.referencedPropertyName, Character.valueOf('.')) : bidirectionalAttributeName;
            this.notFoundAction = null;
            this.isKeyTableNullable = this.isNullable();
            this.isOptional = !bootValue.isConstrained();
            this.isInternalLoadNullable = this.isNullable();
        }
        this.navigableRole = navigableRole;
        this.declaringTableGroupProducer = this.resolveDeclaringTableGroupProducer(declaringEntityPersister);
        if (this.referencedPropertyName == null) {
            targetKeyPropertyNames = new HashSet<String>(2);
            targetKeyPropertyNames.add("{id}");
            entityBinding = bootValue.getBuildingContext().getMetadataCollector().getEntityBinding(entityMappingType.getEntityName());
            Type propertyType = entityBinding.getIdentifierMapper() == null ? entityBinding.getIdentifier().getType() : entityBinding.getIdentifierMapper().getType();
            if (entityBinding.getIdentifierProperty() == null) {
                CompositeType compositeType;
                if (propertyType.isComponentType() && (compositeType = (CompositeType)propertyType).isEmbedded() && compositeType.getPropertyNames().length == 1) {
                    this.targetKeyPropertyName = compositeType.getPropertyNames()[0];
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, this.targetKeyPropertyName, compositeType.getSubtypes()[0], declaringEntityPersister.getFactory());
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, "{fk}", compositeType.getSubtypes()[0], declaringEntityPersister.getFactory());
                } else {
                    this.targetKeyPropertyName = "{id}";
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, null, propertyType, declaringEntityPersister.getFactory());
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, this.targetKeyPropertyName, propertyType, declaringEntityPersister.getFactory());
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, "{fk}", propertyType, declaringEntityPersister.getFactory());
                }
            } else {
                this.targetKeyPropertyName = entityBinding.getIdentifierProperty().getName();
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, this.targetKeyPropertyName, propertyType, declaringEntityPersister.getFactory());
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, "{fk}", propertyType, declaringEntityPersister.getFactory());
            }
            this.targetKeyPropertyNames = targetKeyPropertyNames;
        } else if (bootValue.isReferenceToPrimaryKey()) {
            this.targetKeyPropertyName = this.referencedPropertyName;
            targetKeyPropertyNames = new HashSet(2);
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, this.targetKeyPropertyName, bootValue.getType(), declaringEntityPersister.getFactory());
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, "{fk}", bootValue.getType(), declaringEntityPersister.getFactory());
            this.targetKeyPropertyNames = targetKeyPropertyNames;
        } else {
            CompositeType compositeType;
            PersistentClass entityBinding2 = bootValue.getBuildingContext().getMetadataCollector().getEntityBinding(entityMappingType.getEntityName());
            Type propertyType = entityBinding2.getRecursiveProperty(this.referencedPropertyName).getType();
            if (propertyType.isComponentType() && (compositeType = (CompositeType)propertyType).isEmbedded() && compositeType.getPropertyNames().length == 1) {
                HashSet<String> targetKeyPropertyNames2 = new HashSet<String>(2);
                this.targetKeyPropertyName = compositeType.getPropertyNames()[0];
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames2, this.targetKeyPropertyName, compositeType.getSubtypes()[0], declaringEntityPersister.getFactory());
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames2, "{fk}", compositeType.getSubtypes()[0], declaringEntityPersister.getFactory());
                this.targetKeyPropertyNames = targetKeyPropertyNames2;
            } else {
                this.targetKeyPropertyName = this.referencedPropertyName;
                String mapsIdAttributeName = ToOneAttributeMapping.findMapsIdPropertyName(entityMappingType, this.referencedPropertyName);
                if (mapsIdAttributeName != null) {
                    HashSet<String> targetKeyPropertyNames3 = new HashSet<String>(2);
                    targetKeyPropertyNames3.add(this.targetKeyPropertyName);
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames3, mapsIdAttributeName, entityMappingType.getEntityPersister().getIdentifierType(), declaringEntityPersister.getFactory());
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames3, "{fk}", entityMappingType.getEntityPersister().getIdentifierType(), declaringEntityPersister.getFactory());
                    this.targetKeyPropertyNames = targetKeyPropertyNames3;
                } else {
                    this.targetKeyPropertyNames = Set.of(this.targetKeyPropertyName, "{fk}");
                }
            }
        }
    }

    private static FetchTiming adjustFetchTiming(FetchTiming mappedFetchTiming, ToOne bootValue) {
        if (bootValue instanceof ManyToOne && ((ManyToOne)bootValue).getNotFoundAction() != null) {
            return FetchTiming.IMMEDIATE;
        }
        return mappedFetchTiming;
    }

    private TableGroupProducer resolveDeclaringTableGroupProducer(EntityPersister declaringEntityPersister) {
        NavigableRole parentRole = this.getNavigableRole().getParent();
        String collectionRole = null;
        do {
            CollectionPart.Nature nature;
            if ((nature = CollectionPart.Nature.fromNameExact(parentRole.getLocalName())) == null) continue;
            collectionRole = parentRole.getParent().getFullPath();
            break;
        } while ((parentRole = parentRole.getParent()) != null);
        if (collectionRole != null) {
            return declaringEntityPersister.getFactory().getMappingMetamodel().findCollectionDescriptor(collectionRole).getAttributeMapping();
        }
        return declaringEntityPersister;
    }

    private ToOneAttributeMapping(ToOneAttributeMapping original, ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer) {
        super(original.getAttributeName(), original.getStateArrayPosition(), original.getAttributeMetadataAccess(), original, declaringType, original.getPropertyAccess(), original.getValueGeneration());
        this.navigableRole = original.navigableRole;
        this.sqlAliasStem = original.sqlAliasStem;
        this.isNullable = original.isNullable;
        this.isKeyTableNullable = original.isKeyTableNullable;
        this.isOptional = original.isOptional;
        this.notFoundAction = original.notFoundAction;
        this.unwrapProxy = original.unwrapProxy;
        this.entityMappingType = original.entityMappingType;
        this.referencedPropertyName = original.referencedPropertyName;
        this.targetKeyPropertyName = original.targetKeyPropertyName;
        this.targetKeyPropertyNames = original.targetKeyPropertyNames;
        this.cardinality = original.cardinality;
        this.bidirectionalAttributeName = original.bidirectionalAttributeName;
        this.declaringTableGroupProducer = declaringTableGroupProducer;
        this.isInternalLoadNullable = original.isInternalLoadNullable;
    }

    private static boolean equal(Value lhsValue, Value rhsValue) {
        boolean hasNext;
        Iterator<Selectable> lhsColumns = lhsValue.getColumnIterator();
        Iterator<Selectable> rhsColumns = rhsValue.getColumnIterator();
        do {
            Selectable lhs = lhsColumns.next();
            Selectable rhs = rhsColumns.next();
            if (!lhs.getText().equals(rhs.getText())) {
                return false;
            }
            hasNext = lhsColumns.hasNext();
            if (hasNext == rhsColumns.hasNext()) continue;
            return false;
        } while (hasNext);
        return true;
    }

    static String findMapsIdPropertyName(EntityMappingType entityMappingType, String referencedPropertyName) {
        AbstractEntityPersister persister = (AbstractEntityPersister)entityMappingType.getEntityPersister();
        if (Arrays.equals(persister.getKeyColumnNames(), persister.getPropertyColumnNames(referencedPropertyName))) {
            return persister.getIdentifierPropertyName();
        }
        return null;
    }

    public static void addPrefixedPropertyNames(Set<String> targetKeyPropertyNames, String prefix, Type type, SessionFactoryImplementor factory) {
        if (prefix != null) {
            targetKeyPropertyNames.add(prefix);
        }
        if (type.isComponentType()) {
            ComponentType componentType = (ComponentType)type;
            String[] propertyNames = componentType.getPropertyNames();
            Type[] componentTypeSubtypes = componentType.getSubtypes();
            int propertyNamesLength = propertyNames.length;
            for (int i = 0; i < propertyNamesLength; ++i) {
                Object newPrefix = prefix == null ? propertyNames[i] : prefix + "." + propertyNames[i];
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newPrefix, componentTypeSubtypes[i], factory);
            }
        } else if (type.isEntityType()) {
            Object newFkPrefix;
            Object newPrefix;
            EntityType entityType = (EntityType)type;
            Type identifierOrUniqueKeyType = entityType.getIdentifierOrUniqueKeyType(factory);
            Object propertyName = entityType.isReferenceToPrimaryKey() ? entityType.getAssociatedEntityPersister(factory).getIdentifierPropertyName() : (identifierOrUniqueKeyType instanceof EmbeddedComponentType ? null : entityType.getRHSUniqueKeyPropertyName());
            if (prefix == null) {
                newPrefix = propertyName;
                newFkPrefix = "{fk}";
            } else if (propertyName == null) {
                newPrefix = prefix;
                newFkPrefix = prefix + ".{fk}";
            } else {
                newPrefix = prefix + "." + (String)propertyName;
                newFkPrefix = prefix + ".{fk}";
            }
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newPrefix, identifierOrUniqueKeyType, factory);
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newFkPrefix, identifierOrUniqueKeyType, factory);
        }
    }

    public ToOneAttributeMapping copy(ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer) {
        return new ToOneAttributeMapping(this, declaringType, declaringTableGroupProducer);
    }

    @Override
    public void setForeignKeyDescriptor(ForeignKeyDescriptor foreignKeyDescriptor) {
        assert (this.identifyingColumnsTableExpression != null);
        this.foreignKeyDescriptor = foreignKeyDescriptor;
        this.sideNature = this.cardinality == Cardinality.ONE_TO_ONE && this.bidirectionalAttributeName != null ? ForeignKeyDescriptor.Nature.TARGET : (foreignKeyDescriptor.getAssociationKey().getTable().equals(this.identifyingColumnsTableExpression) ? ForeignKeyDescriptor.Nature.KEY : ForeignKeyDescriptor.Nature.TARGET);
        boolean forceJoin = this.hasNotFoundAction() || this.cardinality == Cardinality.ONE_TO_ONE && this.isNullable();
        this.canUseParentTableGroup = !forceJoin && this.sideNature == ForeignKeyDescriptor.Nature.KEY && this.declaringTableGroupProducer.containsTableReference(this.identifyingColumnsTableExpression);
    }

    public String getIdentifyingColumnsTableExpression() {
        return this.identifyingColumnsTableExpression;
    }

    public void setIdentifyingColumnsTableExpression(String tableExpression) {
        this.identifyingColumnsTableExpression = tableExpression;
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return this.foreignKeyDescriptor;
    }

    @Override
    public ForeignKeyDescriptor.Nature getSideNature() {
        return this.sideNature;
    }

    @Override
    public boolean isReferenceToPrimaryKey() {
        return this.foreignKeyDescriptor.getSide(this.sideNature.inverse()).getModelPart() instanceof EntityIdentifierMapping;
    }

    @Override
    public boolean isFkOptimizationAllowed() {
        return this.canUseParentTableGroup;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    public String getTargetKeyPropertyName() {
        return this.targetKeyPropertyName;
    }

    public Set<String> getTargetKeyPropertyNames() {
        return this.targetKeyPropertyNames;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public EntityMappingType getMappedType() {
        return this.getEntityMappingType();
    }

    @Override
    public EntityMappingType getEntityMappingType() {
        return this.entityMappingType;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public ModelPart findSubPart(String name) {
        return this.findSubPart(name, null);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType targetType) {
        if (this.canUseParentTableGroup && this.targetKeyPropertyNames.contains(name)) {
            ModelPart fkPart = this.sideNature == ForeignKeyDescriptor.Nature.KEY ? this.foreignKeyDescriptor.getKeyPart() : this.foreignKeyDescriptor.getTargetPart();
            if (fkPart instanceof EmbeddableValuedModelPart && fkPart instanceof VirtualModelPart) {
                return ((ModelPartContainer)fkPart).findSubPart(name, targetType);
            }
            return fkPart;
        }
        return EntityValuedFetchable.super.findSubPart(name, targetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fetch resolveCircularFetch(NavigablePath fetchablePath, FetchParent fetchParent, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        AssociationKey associationKey = this.foreignKeyDescriptor.getAssociationKey();
        if (creationState.isAssociationKeyVisited(associationKey) || this.bidirectionalAttributeName != null && !creationState.isRegisteringVisitedAssociationKeys()) {
            DomainResult<?> foreignKeyDomainResult;
            NavigablePath parentNavigablePath = fetchablePath.getParent();
            assert (parentNavigablePath.equals(fetchParent.getNavigablePath()));
            if (parentNavigablePath.getLocalName().equals("{fk}") || parentNavigablePath.getLocalName().equals("{fk-target}")) {
                return null;
            }
            ModelPart parentModelPart = creationState.resolveModelPart(parentNavigablePath);
            if (parentModelPart instanceof EmbeddedIdentifierMappingImpl) {
                while (parentNavigablePath instanceof EntityIdentifierNavigablePath) {
                    parentNavigablePath = parentNavigablePath.getParent();
                    assert (parentNavigablePath != null);
                    parentModelPart = creationState.resolveModelPart(parentNavigablePath);
                }
            }
            while (parentModelPart instanceof EmbeddableValuedFetchable) {
                parentNavigablePath = parentNavigablePath.getParent();
                assert (parentNavigablePath != null);
                parentModelPart = creationState.resolveModelPart(parentNavigablePath);
            }
            if (this.isBidirectionalAttributeName(parentNavigablePath, parentModelPart, fetchablePath, creationState)) {
                return this.createCircularBiDirectionalFetch(fetchablePath, fetchParent, parentNavigablePath, fetchTiming, creationState);
            }
            TableGroup parentTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
            assert (!creationState.isResolvingCircularFetch());
            try {
                creationState.setResolvingCircularFetch(true);
                foreignKeyDomainResult = this.foreignKeyDescriptor.createDomainResult(fetchablePath, parentTableGroup, this.sideNature, fetchParent, creationState);
            }
            finally {
                creationState.setResolvingCircularFetch(false);
            }
            return new CircularFetchImpl(this, this.getEntityMappingType(), fetchTiming, fetchablePath, fetchParent, this, this.isSelectByUniqueKey(this.sideNature), fetchablePath, foreignKeyDomainResult);
        }
        return null;
    }

    protected boolean isBidirectionalAttributeName(NavigablePath parentNavigablePath, ModelPart parentModelPart, NavigablePath fetchablePath, DomainResultCreationState creationState) {
        if (this.bidirectionalAttributeName == null) {
            if (parentModelPart instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)parentModelPart;
                if (toOneAttributeMapping.bidirectionalAttributeName != null) {
                    return toOneAttributeMapping.isBidirectionalAttributeName(fetchablePath, this, parentNavigablePath, creationState);
                }
            } else {
                if (parentModelPart instanceof PluralAttributeMapping) {
                    return parentNavigablePath.getParent() != null && ((PluralAttributeMapping)parentModelPart).isBidirectionalAttributeName(fetchablePath, this);
                }
                if (parentModelPart instanceof EntityCollectionPart) {
                    NavigablePath parentOfParent = parentNavigablePath.getParent();
                    if (parentOfParent instanceof EntityIdentifierNavigablePath) {
                        parentOfParent = parentOfParent.getParent();
                    }
                    return parentOfParent.getParent() != null && ((PluralAttributeMapping)creationState.resolveModelPart(parentOfParent)).isBidirectionalAttributeName(fetchablePath, this);
                }
            }
            return false;
        }
        if (this.cardinality == Cardinality.MANY_TO_ONE) {
            NavigablePath grandparentNavigablePath = parentNavigablePath.getParent();
            if (parentNavigablePath.getLocalName().equals(CollectionPart.Nature.ELEMENT.getName()) && grandparentNavigablePath != null && grandparentNavigablePath.getLocalName().equals(this.bidirectionalAttributeName)) {
                NavigablePath parentPath = grandparentNavigablePath.getParent();
                if (parentPath == null) {
                    return grandparentNavigablePath.equals(this.entityMappingType.findSubPart(this.bidirectionalAttributeName).getNavigableRole());
                }
                if (parentPath.getParent() == null) {
                    String entityName = this.entityMappingType.getPartName();
                    return parentPath.getFullPath().startsWith(entityName) && (parentPath.getFullPath().length() == entityName.length() || parentPath.getFullPath().charAt(entityName.length()) == '(');
                }
                return parentPath.getLocalName().equals(this.navigableRole.getLocalName());
            }
            return false;
        }
        return parentNavigablePath.getLocalName().equals(this.bidirectionalAttributeName);
    }

    public String getBidirectionalAttributeName() {
        return this.bidirectionalAttributeName;
    }

    private Fetch createCircularBiDirectionalFetch(NavigablePath fetchablePath, FetchParent fetchParent, NavigablePath parentNavigablePath, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        boolean hasBidirectionalFetchParent;
        NavigablePath referencedNavigablePath;
        FetchParent realFetchParent = fetchParent;
        while (realFetchParent.getNavigablePath() != parentNavigablePath) {
            realFetchParent = ((Fetch)((Object)fetchParent)).getFetchParent();
        }
        if (parentNavigablePath.getParent() == null) {
            referencedNavigablePath = parentNavigablePath;
            hasBidirectionalFetchParent = true;
        } else if (CollectionPart.Nature.fromNameExact(parentNavigablePath.getLocalName()) != null) {
            referencedNavigablePath = this.getReferencedNavigablePath(creationState, parentNavigablePath.getParent());
            hasBidirectionalFetchParent = fetchParent instanceof Fetch && ((Fetch)((Object)fetchParent)).getFetchParent() instanceof Fetch;
        } else {
            referencedNavigablePath = this.getReferencedNavigablePath(creationState, parentNavigablePath);
            hasBidirectionalFetchParent = fetchParent instanceof Fetch;
        }
        if (referencedNavigablePath != null) {
            DomainResult<?> keyDomainResult = this.sideNature == ForeignKeyDescriptor.Nature.KEY && !this.isKeyTableNullable ? this.foreignKeyDescriptor.createKeyDomainResult(fetchablePath, creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(realFetchParent.getNavigablePath()), fetchParent, creationState) : null;
            if (hasBidirectionalFetchParent) {
                return new CircularBiDirectionalFetchImpl(FetchTiming.IMMEDIATE, fetchablePath, fetchParent, this, LockMode.READ, referencedNavigablePath, keyDomainResult);
            }
            FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
            TableGroup tableGroup = fromClauseAccess.getTableGroup(referencedNavigablePath);
            fromClauseAccess.registerTableGroup(fetchablePath, tableGroup);
            return new EntityFetchJoinedImpl(fetchParent, this, tableGroup, keyDomainResult, fetchablePath, creationState);
        }
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        NavigablePath realParent = CollectionPart.Nature.fromNameExact(parentNavigablePath.getLocalName()) != null ? parentNavigablePath.getParent() : parentNavigablePath;
        TableGroup tableGroup = fromClauseAccess.getTableGroup(realParent);
        DomainResult<?> domainResult = this.foreignKeyDescriptor.createDomainResult(fetchablePath, tableGroup, this.sideNature, fetchParent, creationState);
        if (fetchTiming == FetchTiming.IMMEDIATE) {
            return new EntityFetchSelectImpl(fetchParent, this, fetchablePath, domainResult, this.isSelectByUniqueKey(this.sideNature), creationState);
        }
        return new EntityDelayedFetchImpl(fetchParent, this, fetchablePath, domainResult, this.isSelectByUniqueKey(this.sideNature));
    }

    private NavigablePath getReferencedNavigablePath(DomainResultCreationState creationState, NavigablePath parentNavigablePath) {
        NavigablePath referencedNavigablePath = parentNavigablePath.getParent();
        MappingType partMappingType = creationState.resolveModelPart(referencedNavigablePath).getPartMappingType();
        while (!(partMappingType instanceof EntityMappingType) || partMappingType != this.entityMappingType && !this.entityMappingType.getEntityPersister().isSubclassEntityName(partMappingType.getMappedJavaType().getJavaType().getTypeName()) && !((EntityMappingType)partMappingType).getEntityPersister().isSubclassEntityName(this.entityMappingType.getEntityName())) {
            if ((referencedNavigablePath = referencedNavigablePath.getParent()) == null) {
                return null;
            }
            partMappingType = creationState.resolveModelPart(referencedNavigablePath).getPartMappingType();
        }
        return referencedNavigablePath;
    }

    @Override
    public EntityFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        TableGroup parentTableGroup = fromClauseAccess.getTableGroup(fetchParent.getNavigablePath());
        NavigablePath parentNavigablePath = fetchablePath.getParent();
        assert (parentNavigablePath.equals(fetchParent.getNavigablePath()) || fetchParent.getNavigablePath() instanceof TreatedNavigablePath && parentNavigablePath.equals(fetchParent.getNavigablePath().getRealParent()));
        if (fetchTiming == FetchTiming.IMMEDIATE && selected || this.hasNotFoundAction()) {
            TableGroup tableGroup = this.determineTableGroupForFetch(fetchablePath, fetchParent, parentTableGroup, resultVariable, fromClauseAccess, creationState);
            return this.withRegisteredAssociationKeys(() -> {
                DomainResult<?> keyResult = this.notFoundAction != null ? (this.sideNature == ForeignKeyDescriptor.Nature.KEY ? this.foreignKeyDescriptor.createKeyDomainResult(fetchablePath, parentTableGroup, fetchParent, creationState) : this.foreignKeyDescriptor.createTargetDomainResult(fetchablePath, parentTableGroup, fetchParent, creationState)) : null;
                return new EntityFetchJoinedImpl(fetchParent, this, tableGroup, keyResult, fetchablePath, creationState);
            }, creationState);
        }
        ForeignKeyDescriptor.Nature resolvingKeySideOfForeignKey = creationState.getCurrentlyResolvingForeignKeyPart();
        ForeignKeyDescriptor.Nature side = resolvingKeySideOfForeignKey == ForeignKeyDescriptor.Nature.KEY && this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? ForeignKeyDescriptor.Nature.KEY : this.sideNature;
        DomainResult<?> keyResult = this.foreignKeyDescriptor.createDomainResult(fetchablePath, parentTableGroup, side, fetchParent, creationState);
        boolean selectByUniqueKey = this.isSelectByUniqueKey(side);
        if (fetchTiming == FetchTiming.IMMEDIATE) {
            return new EntityFetchSelectImpl(fetchParent, this, fetchablePath, keyResult, selectByUniqueKey, creationState);
        }
        return new EntityDelayedFetchImpl(fetchParent, this, fetchablePath, keyResult, selectByUniqueKey);
    }

    private TableGroup determineTableGroupForFetch(NavigablePath fetchablePath, FetchParent fetchParent, TableGroup parentTableGroup, String resultVariable, FromClauseAccess fromClauseAccess, DomainResultCreationState creationState) {
        SqlAstJoinType joinType = fetchParent instanceof EntityResultJoinedSubclassImpl && ((EntityPersister)fetchParent.getReferencedModePart()).findDeclaredAttributeMapping(this.getPartName()) == null ? this.getJoinTypeForFetch(fetchablePath, parentTableGroup) : null;
        return fromClauseAccess.resolveTableGroup(fetchablePath, np -> {
            TableGroup leftJoined = null;
            for (TableGroupJoin tableGroupJoin : parentTableGroup.getTableGroupJoins()) {
                switch (tableGroupJoin.getJoinType()) {
                    case INNER: {
                        if (!tableGroupJoin.getNavigablePath().pathsMatch((NavigablePath)np)) break;
                        return tableGroupJoin.getJoinedGroup();
                    }
                    case LEFT: {
                        if (!tableGroupJoin.getNavigablePath().pathsMatch((NavigablePath)np) || !this.isSimpleJoinPredicate(tableGroupJoin.getPredicate())) break;
                        leftJoined = tableGroupJoin.getJoinedGroup();
                    }
                }
            }
            if (leftJoined != null) {
                return leftJoined;
            }
            TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, parentTableGroup, resultVariable, joinType, true, false, creationState.getSqlAstCreationState());
            parentTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
    }

    private boolean isSelectByUniqueKey(ForeignKeyDescriptor.Nature side) {
        if (side == ForeignKeyDescriptor.Nature.KEY) {
            return !this.foreignKeyDescriptor.getNavigableRole().equals(this.entityMappingType.getIdentifierMapping().getNavigableRole());
        }
        return this.bidirectionalAttributeName != null && (!(this.entityMappingType.getIdentifierMapping() instanceof SingleAttributeIdentifierMapping) || !this.targetKeyPropertyNames.contains(((SingleAttributeIdentifierMapping)this.entityMappingType.getIdentifierMapping()).getAttributeName()));
    }

    @Override
    public <T> DomainResult<T> createSnapshotDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        boolean forceJoin = this.hasNotFoundAction() || this.sideNature == ForeignKeyDescriptor.Nature.TARGET || this.referencedPropertyName != null;
        TableGroup tableGroupToUse = forceJoin ? creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(navigablePath, np -> {
            TableGroupJoin tableGroupJoin = this.createTableGroupJoin(navigablePath, tableGroup, null, this.getDefaultSqlAstJoinType(tableGroup), true, false, creationState.getSqlAstCreationState());
            tableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        }) : tableGroup;
        if (this.hasNotFoundAction()) {
            assert (tableGroupToUse != tableGroup);
            return new NotFoundSnapshotResult(navigablePath, this, tableGroupToUse, tableGroup, creationState);
        }
        if (this.referencedPropertyName == null) {
            return new EntityDelayedResultImpl(navigablePath.append("{id}"), this, tableGroupToUse, creationState);
        }
        EntityResultImpl entityResult = new EntityResultImpl(navigablePath, this, tableGroupToUse, null, creationState);
        entityResult.afterInitialize(entityResult, creationState);
        return entityResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityFetch withRegisteredAssociationKeys(Supplier<EntityFetch> fetchCreator, DomainResultCreationState creationState) {
        ModelPart bidirectionalModelPart;
        boolean added = creationState.registerVisitedAssociationKey(this.foreignKeyDescriptor.getAssociationKey());
        AssociationKey additionalAssociationKey = null;
        if (this.cardinality == Cardinality.LOGICAL_ONE_TO_ONE && this.bidirectionalAttributeName != null && (bidirectionalModelPart = this.entityMappingType.findSubPart(this.bidirectionalAttributeName)) instanceof ToOneAttributeMapping) {
            assert (bidirectionalModelPart.getPartMappingType() == this.declaringTableGroupProducer);
            ToOneAttributeMapping bidirectionalAttribute = (ToOneAttributeMapping)bidirectionalModelPart;
            AssociationKey secondKey = bidirectionalAttribute.getForeignKeyDescriptor().getAssociationKey();
            if (creationState.registerVisitedAssociationKey(secondKey)) {
                additionalAssociationKey = secondKey;
            }
        }
        try {
            EntityFetch entityFetch = fetchCreator.get();
            return entityFetch;
        }
        finally {
            if (added) {
                creationState.removeVisitedAssociationKey(this.foreignKeyDescriptor.getAssociationKey());
            }
            if (additionalAssociationKey != null) {
                creationState.removeVisitedAssociationKey(additionalAssociationKey);
            }
        }
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        Class<?> parentTableGroupType;
        Class<?> attributeDeclaringType;
        if (this.isKeyTableNullable || this.isNullable) {
            return SqlAstJoinType.LEFT;
        }
        if (parentTableGroup.getModelPart() instanceof CollectionPart) {
            return SqlAstJoinType.LEFT;
        }
        if (parentTableGroup.canUseInnerJoins() && (attributeDeclaringType = this.declaringTableGroupProducer.getJavaType().getJavaTypeClass()).isAssignableFrom(parentTableGroupType = parentTableGroup.getModelPart().getJavaType().getJavaTypeClass())) {
            return SqlAstJoinType.INNER;
        }
        return SqlAstJoinType.LEFT;
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        return predicate == null || this.foreignKeyDescriptor.isSimpleJoinPredicate(predicate);
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEntityMappingType().getNumberOfFetchables();
    }

    @Override
    public Fetchable getFetchable(int position) {
        return this.getEntityMappingType().getFetchable(position);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        assert (!(lhs instanceof PluralTableGroup));
        SqlAstJoinType joinType = requestedJoinType == null ? (fetched ? this.getDefaultSqlAstJoinType(lhs) : SqlAstJoinType.INNER) : requestedJoinType;
        if (!(addsPredicate || joinType != SqlAstJoinType.INNER && joinType != SqlAstJoinType.LEFT)) {
            PluralTableGroup pluralTableGroup;
            String indexPropertyName;
            String pathName;
            TableGroup parentTableGroup = lhs;
            ModelPartContainer parentContainer = lhs.getModelPart();
            StringBuilder embeddablePathSb = null;
            while (!(parentContainer instanceof CollectionPart) && parentContainer instanceof EmbeddableValuedModelPart) {
                if (embeddablePathSb == null) {
                    embeddablePathSb = new StringBuilder();
                }
                embeddablePathSb.insert(0, parentContainer.getPartName() + ".");
                parentTableGroup = fromClauseAccess.findTableGroup(parentTableGroup.getNavigablePath().getParent());
                parentContainer = parentTableGroup.getModelPart();
            }
            if (CollectionPart.Nature.ELEMENT.getName().equals(parentTableGroup.getNavigablePath().getLocalName()) && (pathName = embeddablePathSb != null ? embeddablePathSb.append(this.getAttributeName()).toString() : this.getAttributeName()).equals(indexPropertyName = (pluralTableGroup = (PluralTableGroup)fromClauseAccess.findTableGroup(parentTableGroup.getNavigablePath().getParent())).getModelPart().getIndexMetadata().getIndexPropertyName())) {
                TableGroup indexTableGroup = pluralTableGroup.getIndexTableGroup();
                this.initializeIfNeeded(lhs, requestedJoinType, indexTableGroup);
                return new TableGroupJoin(navigablePath, joinType, new MappedByTableGroup(navigablePath, this, indexTableGroup, fetched, pluralTableGroup, (np, tableExpression) -> {
                    if (!this.canUseParentTableGroup) {
                        return false;
                    }
                    if (!this.identifyingColumnsTableExpression.equals(tableExpression)) {
                        return false;
                    }
                    if (navigablePath.equals(np.getParent())) {
                        return this.targetKeyPropertyNames.contains(np.getLocalName());
                    }
                    String relativePath = np.relativize(navigablePath);
                    if (relativePath == null) {
                        return false;
                    }
                    return relativePath.isEmpty() || this.targetKeyPropertyNames.contains(relativePath);
                }), null);
            }
        }
        TableGroup lazyTableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, requestedJoinType, fetched, (Consumer)null, aliasBaseGenerator, sqlExpressionResolver, fromClauseAccess, creationContext);
        TableGroupJoin join = new TableGroupJoin(navigablePath, joinType, lazyTableGroup, null);
        TableReference lhsTableReference = lhs.resolveTableReference(navigablePath, this.identifyingColumnsTableExpression);
        ((LazyTableGroup)lazyTableGroup).setTableGroupInitializerCallback(tableGroup -> {
            TableReference keyTableReference;
            TableReference targetTableReference;
            if (this.sideNature == ForeignKeyDescriptor.Nature.TARGET) {
                targetTableReference = lhsTableReference;
                keyTableReference = tableGroup.resolveTableReference(this.foreignKeyDescriptor.getKeyTable());
            } else {
                targetTableReference = tableGroup.resolveTableReference(this.foreignKeyDescriptor.getTargetTable());
                keyTableReference = lhsTableReference;
            }
            join.applyPredicate(this.foreignKeyDescriptor.generateJoinPredicate(targetTableReference, keyTableReference, sqlExpressionResolver, creationContext));
            if (this.hasNotFoundAction()) {
                this.getAssociatedEntityMappingType().applyWhereRestrictions(join::applyPredicate, (TableGroup)tableGroup, true, null);
            }
        });
        return join;
    }

    @Override
    public LazyTableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(this.sqlAliasStem);
        boolean canUseInnerJoin = !lhs.canUseInnerJoins() ? false : (this.isNullable || this.hasNotFoundAction() ? false : requestedJoinType == SqlAstJoinType.INNER);
        TableGroup realParentTableGroup = lhs;
        while (realParentTableGroup.getModelPart() instanceof EmbeddableValuedModelPart) {
            realParentTableGroup = fromClauseAccess.findTableGroup(realParentTableGroup.getNavigablePath().getParent());
        }
        EntityValuedModelPart tableGroupProducer = realParentTableGroup instanceof CorrelatedTableGroup ? this.entityMappingType : this;
        LazyTableGroup lazyTableGroup = new LazyTableGroup(canUseInnerJoin, navigablePath, fetched, () -> this.createTableGroupInternal(canUseInnerJoin, navigablePath, fetched, null, sqlAliasBase, sqlExpressionResolver, creationContext), (arg_0, arg_1) -> this.lambda$createRootTableGroupJoin$6((TableGroupProducer)((Object)tableGroupProducer), navigablePath, arg_0, arg_1), (TableGroupProducer)((Object)tableGroupProducer), explicitSourceAlias, sqlAliasBase, creationContext.getSessionFactory(), lhs);
        if (predicateConsumer != null) {
            TableReference lhsTableReference = lhs.resolveTableReference(navigablePath, this.identifyingColumnsTableExpression);
            lazyTableGroup.setTableGroupInitializerCallback(tableGroup -> predicateConsumer.accept(this.foreignKeyDescriptor.generateJoinPredicate(this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? lhsTableReference : tableGroup.getPrimaryTableReference(), this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? tableGroup.getPrimaryTableReference() : lhsTableReference, sqlExpressionResolver, creationContext)));
        }
        if (realParentTableGroup instanceof CorrelatedTableGroup) {
            lazyTableGroup.getPrimaryTableReference();
        } else {
            this.initializeIfNeeded(lhs, requestedJoinType, lazyTableGroup);
        }
        return lazyTableGroup;
    }

    private void initializeIfNeeded(TableGroup lhs, SqlAstJoinType sqlAstJoinType, TableGroup tableGroup) {
        if (sqlAstJoinType == SqlAstJoinType.INNER && (this.isNullable || !lhs.canUseInnerJoins())) {
            tableGroup.getPrimaryTableReference();
        }
    }

    private SqlAstJoinType getJoinTypeForFetch(NavigablePath navigablePath, TableGroup tableGroup) {
        for (TableGroupJoin tableGroupJoin : tableGroup.getTableGroupJoins()) {
            if (!tableGroupJoin.getNavigablePath().equals(navigablePath)) continue;
            return tableGroupJoin.getJoinType();
        }
        return null;
    }

    public TableGroup createTableGroupInternal(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference primaryTableReference = this.getEntityMappingType().createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
        return new StandardTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, primaryTableReference, true, sqlAliasBase, tableExpression -> this.getEntityMappingType().containsTableReference((String)tableExpression), (tableExpression, tg) -> this.getEntityMappingType().createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, sqlExpressionResolver, creationContext), creationContext.getSessionFactory());
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isInternalLoadNullable() {
        return this.isInternalLoadNullable;
    }

    public NotFoundAction getNotFoundAction() {
        return this.notFoundAction;
    }

    public boolean isIgnoreNotFound() {
        return this.notFoundAction == NotFoundAction.IGNORE;
    }

    public boolean hasNotFoundAction() {
        return this.notFoundAction != null;
    }

    @Override
    public boolean isUnwrapProxy() {
        return this.unwrapProxy;
    }

    @Override
    public EntityMappingType getAssociatedEntityMappingType() {
        return this.getEntityMappingType();
    }

    @Override
    public ModelPart getKeyTargetMatchPart() {
        return this.foreignKeyDescriptor.getPart(this.sideNature);
    }

    public String toString() {
        return "ToOneAttributeMapping(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.foreignKeyDescriptor.breakDownJdbcValues(this.foreignKeyDescriptor.getAssociationKeyFromSide(domainValue, this.sideNature.inverse(), session), valueConsumer, session);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            return this.foreignKeyDescriptor.visitKeySelectables(offset, consumer);
        }
        return 0;
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            this.foreignKeyDescriptor.getKeyPart().applySqlSelections(navigablePath, tableGroup, creationState);
        }
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            this.foreignKeyDescriptor.getKeyPart().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
        }
    }

    @Override
    public int getJdbcTypeCount() {
        return this.foreignKeyDescriptor.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.foreignKeyDescriptor.forEachJdbcType(offset, action);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.disassemble(this.foreignKeyDescriptor.getAssociationKeyFromSide(value, this.sideNature.inverse(), session), session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer consumer, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.forEachDisassembledJdbcValue(this.foreignKeyDescriptor.disassemble(this.foreignKeyDescriptor.getAssociationKeyFromSide(value, this.sideNature.inverse(), session), session), clause, offset, consumer, session);
    }

    private /* synthetic */ boolean lambda$createRootTableGroupJoin$6(TableGroupProducer tableGroupProducer, NavigablePath navigablePath, NavigablePath np, String tableExpression) {
        if (!this.canUseParentTableGroup || tableGroupProducer != this) {
            return false;
        }
        if (!this.identifyingColumnsTableExpression.equals(tableExpression)) {
            return false;
        }
        if (navigablePath.pathsMatch(np.getParent())) {
            return this.targetKeyPropertyNames.contains(np.getLocalName());
        }
        String relativePath = np.relativize(navigablePath);
        if (relativePath == null) {
            return false;
        }
        return relativePath.isEmpty() || this.targetKeyPropertyNames.contains(relativePath);
    }

    public static enum Cardinality {
        ONE_TO_ONE,
        MANY_TO_ONE,
        LOGICAL_ONE_TO_ONE;

    }
}

