/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.InnoDBStorageEngine;
import org.hibernate.dialect.MariaDBSqlAstTranslator;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.MySQLServerConfiguration;
import org.hibernate.dialect.MySQLStorageEngine;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.sequence.MariaDBSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorMariaDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;

public class MariaDBDialect
extends MySQLDialect {
    private static final DatabaseVersion VERSION5 = DatabaseVersion.make(5);
    private static final DatabaseVersion VERSION57 = DatabaseVersion.make(5, 7);

    public MariaDBDialect() {
        this(DatabaseVersion.make(5));
    }

    public MariaDBDialect(DatabaseVersion version) {
        super(version);
    }

    public MariaDBDialect(DialectResolutionInfo info) {
        super(MariaDBDialect.createVersion(info), MySQLServerConfiguration.fromDatabaseMetadata(info.getDatabaseMetadata()));
        this.registerKeywords(info);
    }

    @Override
    public DatabaseVersion getMySQLVersion() {
        return this.getVersion().isBefore(5, 3) ? VERSION5 : VERSION57;
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        if (this.getVersion().isSameOrAfter(10, 2)) {
            CommonFunctionFactory commonFunctionFactory = new CommonFunctionFactory(queryEngine);
            commonFunctionFactory.windowFunctions();
            commonFunctionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
            queryEngine.getSqmFunctionRegistry().registerNamed("json_valid", queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN));
            if (this.getVersion().isSameOrAfter(10, 3, 3)) {
                commonFunctionFactory.inverseDistributionOrderedSetAggregates_windowEmulation();
            }
        }
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new MariaDBSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(10, 2);
    }

    @Override
    public boolean supportsColumnCheck() {
        return this.getVersion().isSameOrAfter(10, 2);
    }

    @Override
    protected MySQLStorageEngine getDefaultMySQLStorageEngine() {
        return InnoDBStorageEngine.INSTANCE;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return this.getVersion().isSameOrAfter(10);
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return this.getVersion().isSameOrAfter(10, 5);
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion().isBefore(10, 3) ? super.getSequenceSupport() : MariaDBSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getSequenceSupport().supportsSequences() ? "select table_name from information_schema.TABLES where table_schema=database() and table_type='SEQUENCE'" : super.getQuerySequencesString();
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getSequenceSupport().supportsSequences() ? SequenceInformationExtractorMariaDBDatabaseImpl.INSTANCE : super.getSequenceInformationExtractor();
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getVersion().isSameOrAfter(10, 6);
    }

    @Override
    public boolean supportsNoWait() {
        return this.getVersion().isSameOrAfter(10, 3);
    }

    @Override
    public boolean supportsWait() {
        return this.getVersion().isSameOrAfter(10, 3);
    }

    @Override
    boolean supportsForShare() {
        return false;
    }

    @Override
    boolean supportsAliasLocks() {
        return false;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }
}

